package com.liquidnet.client.admin.zhengzai.goblin.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.zhengzai.goblin.service.IGoblinFrontBannerService;
import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.goblin.constant.GoblinRedisConst;
import com.liquidnet.service.goblin.entity.GoblinFrontBanner;
import com.liquidnet.service.goblin.mapper.GoblinFrontBannerMapper;
import com.liquidnet.service.goblin.param.GoblinFrontBannerBuildParam;
import com.mongodb.BasicDBObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 轮播图 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Service
public class GoblinFrontBannerServiceImpl extends ServiceImpl<GoblinFrontBannerMapper, GoblinFrontBanner> implements IGoblinFrontBannerService {
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    GoblinFrontBannerMapper goblinFrontBannerMapper;
    @Autowired
    private RedisDataSourceUtil redisDataSourceUtil;

    public boolean create(GoblinFrontBanner goblinFrontBanner){
        goblinFrontBanner.setCreateTime(LocalDateTime.now());
        goblinFrontBanner.setUpdateTime(LocalDateTime.now());
        //设置bannerid
        goblinFrontBanner.setBannerId(IDGenerator.nextSnowId());
        //增加 banner
        goblinFrontBannerMapper.insert(goblinFrontBanner);
     /*   //mongo  db增加
        mongoTemplate.save(goblinFrontBanner,GoblinFrontBanner.class.getSimpleName());
        //redis 增加
        LambdaQueryWrapper<GoblinFrontBanner> queryWrapper = Wrappers.lambdaQuery(GoblinFrontBanner.class);
        queryWrapper.ne(GoblinFrontBanner::getDelTag,1);
        queryWrapper.orderByDesc(GoblinFrontBanner::getIndexs);
        List<GoblinFrontBanner> list=goblinFrontBannerMapper.selectList(queryWrapper);
        redisDataSourceUtil.getRedisGoblinUtil().set(GoblinRedisConst.FRONT_BANNER,list);*/
        return true;
    }
    /***
     * @author zhangfuxin
     * @Description: 修改
     * @date 2021/12/27 下午4:03
     */
    public boolean update(  List<GoblinFrontBanner> list){
        for(GoblinFrontBanner goblinFrontBanner:list){
            if(goblinFrontBanner.getMid()==0){
                this.create(goblinFrontBanner);
            }else{
                goblinFrontBanner.setUpdateTime(LocalDateTime.now());
                //数据库修改
                goblinFrontBannerMapper.updateById(goblinFrontBanner);
            }
        }


       /* //mongodb修改
        BasicDBObject orderObject = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(goblinFrontBanner)));
        mongoTemplate.getCollection(GoblinFrontBanner.class.getSimpleName()).updateOne(
                Query.query(Criteria.where("bannerId").is(goblinFrontBanner.getBannerId())).getQueryObject(),
                orderObject
        );
        //redis 修改
        //从数据库中查出来，从新塞进去
        LambdaQueryWrapper<GoblinFrontBanner> queryWrapper = Wrappers.lambdaQuery(GoblinFrontBanner.class);
        queryWrapper.ne(GoblinFrontBanner::getDelTag,1);
        queryWrapper.orderByDesc(GoblinFrontBanner::getIndexs);
        List<GoblinFrontBanner> list=goblinFrontBannerMapper.selectList(queryWrapper);
        redisDataSourceUtil.getRedisGoblinUtil().set(GoblinRedisConst.FRONT_BANNER,list);*/
        return true;
    }
    /**
     * @author zhangfuxin
     * @Description:查看详情
     * @date 2021/12/27 下午4:34
     */
    public GoblinFrontBanner getOne(Long id){
        return  goblinFrontBannerMapper.selectById(id);
    }
    /**
     * @author zhangfuxin
     * @Description:  删除 banner
     * @date 2021/12/27 下午4:36
     */
    public boolean delte(Long id){
        GoblinFrontBanner goblinFrontBanner=goblinFrontBannerMapper.selectById(id);
        goblinFrontBanner.setDelTag(1);
        goblinFrontBanner.setUpdateTime(LocalDateTime.now());
        //数据库修改
        goblinFrontBannerMapper.updateById(goblinFrontBanner);
        return true;
    }
    /**
     * @author zhangfuxin
     * @Description:分页
     * @date 2021/12/27 下午5:19
     */
    public PageInfo<GoblinFrontBanner> bannerPage(int pageSize,int pageNumber,GoblinFrontBanner goblinFrontBanner) {
        PageInfo<GoblinFrontBanner> pageInfoTmp = null;
        try {
          //  PageHelper.startPage(pageNumber, pageSize);
            LambdaQueryWrapper<GoblinFrontBanner> queryWrapper = Wrappers.lambdaQuery(GoblinFrontBanner.class);
            queryWrapper.orderByDesc(GoblinFrontBanner::getIndexs);
            List<GoblinFrontBanner> list=goblinFrontBannerMapper.selectList(queryWrapper);
            pageInfoTmp = new PageInfo(list);
        } catch (Exception e) {
            return new PageInfo();
        }
        return pageInfoTmp;
    }
    public List<GoblinFrontBannerBuildParam> listGoblinFrontBanner(String type) {
        //banner_type  1、首页顶部位置2、首页中部位置
        //  PageHelper.startPage(pageNumber, pageSize);
        LambdaQueryWrapper<GoblinFrontBanner> queryWrapper = Wrappers.lambdaQuery(GoblinFrontBanner.class);
        queryWrapper.eq(GoblinFrontBanner::getBannerType,type);
        queryWrapper.ne(GoblinFrontBanner::getDelTag,1);
        queryWrapper.orderByAsc(GoblinFrontBanner::getIndexs);
        List<GoblinFrontBanner> list=goblinFrontBannerMapper.selectList(queryWrapper);
        List<GoblinFrontBannerBuildParam> list1=new ArrayList();
        for(GoblinFrontBanner goblinFrontBanner:list){
            GoblinFrontBannerBuildParam goblinFrontBannerBuildParam=new GoblinFrontBannerBuildParam();
            BeanUtils.copyProperties(goblinFrontBanner,goblinFrontBannerBuildParam);
            list1.add(goblinFrontBannerBuildParam);
        }
        return list1;
    }
    public boolean online(){
        //首页顶部
        //banner
        LambdaQueryWrapper<GoblinFrontBanner> queryWrapper = Wrappers.lambdaQuery(GoblinFrontBanner.class);
        queryWrapper.ne(GoblinFrontBanner::getDelTag,1);
        //bannerType
        queryWrapper.eq(GoblinFrontBanner::getBannerType,1);
        queryWrapper.orderByAsc(GoblinFrontBanner::getIndexs);
        List<GoblinFrontBanner> list=goblinFrontBannerMapper.selectList(queryWrapper);
        if(list.size()>0){
            //mongodb
            for(GoblinFrontBanner goblinFrontBanner: list){
                GoblinFrontBanner goblinFrontBanner1=mongoTemplate.findOne(Query.query(Criteria.where("bannerId").is(goblinFrontBanner.getBannerId())), GoblinFrontBanner.class, GoblinFrontBanner.class.getSimpleName());
                if(null==goblinFrontBanner1){
                    mongoTemplate.save(goblinFrontBanner,GoblinFrontBanner.class.getSimpleName());
                }else{
                    BasicDBObject orderObject = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(goblinFrontBanner)));
                    mongoTemplate.getCollection(GoblinFrontBanner.class.getSimpleName()).updateOne(
                            Query.query(Criteria.where("bannerId").is(goblinFrontBanner.getBannerId())).getQueryObject(),
                            orderObject
                    );
                }
            }
        }
        //redis
        redisDataSourceUtil.getRedisGoblinUtil().set(GoblinRedisConst.FRONT_TOP_BANNER,list);
        return true;
    }
    public boolean middle(){
        LambdaQueryWrapper<GoblinFrontBanner> queryWrapper = Wrappers.lambdaQuery(GoblinFrontBanner.class);
        queryWrapper.ne(GoblinFrontBanner::getDelTag,1);
        //bannerType
        queryWrapper.eq(GoblinFrontBanner::getBannerType,2);
        queryWrapper.orderByDesc(GoblinFrontBanner::getIndexs);
        List<GoblinFrontBanner> list=goblinFrontBannerMapper.selectList(queryWrapper);
        if(list.size()>0){
            //mongodb
            for(GoblinFrontBanner goblinFrontBanner: list){
                GoblinFrontBanner goblinFrontBanner1=mongoTemplate.findOne(Query.query(Criteria.where("bannerId").is(goblinFrontBanner.getBannerId())), GoblinFrontBanner.class, GoblinFrontBanner.class.getSimpleName());
                if(null==goblinFrontBanner1){
                    mongoTemplate.save(goblinFrontBanner,GoblinFrontBanner.class.getSimpleName());
                }else{
                    BasicDBObject orderObject = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(goblinFrontBanner)));
                    mongoTemplate.getCollection(GoblinFrontBanner.class.getSimpleName()).updateOne(
                            Query.query(Criteria.where("bannerId").is(goblinFrontBanner.getBannerId())).getQueryObject(),
                            orderObject
                    );
                }
            }
            //redis
            redisDataSourceUtil.getRedisGoblinUtil().set(GoblinRedisConst.FRONT_MIDDLE_BANNER,list);
        }
        return true;

    }



}
