package com.liquidnet.service.sweet.handler;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.sweet.config.WechatMpConfigure;
import com.liquidnet.service.sweet.utils.QueueUtils;
import com.liquidnet.service.sweet.utils.WechatUsersRedisUtils;
import com.liquidnet.service.sweet.vo.SweetWechatUsersVo;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.mp.api.WxMpMessageHandler;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.LinkedList;
import java.util.Map;

/**
 * <p>
 * 取消关注
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-07-31 5:08 下午
 */
@Component
@Slf4j
public class UnsubscribeHandler implements WxMpMessageHandler {

    @Autowired
    private WechatUsersRedisUtils redisUtils;
    @Autowired
    private QueueUtils queueUtils;
    @Autowired
    WechatMpConfigure wechatMpConfigure;

    @Override
    public WxMpXmlOutMessage handle(WxMpXmlMessage wxMessage, Map<String, Object> context, WxMpService wxMpService,
                                    WxSessionManager sessionManager) throws WxErrorException {
        String zhengzaiAppId = wechatMpConfigure.getWxMpService(1).getWxMpConfigStorage().getAppId();
        String otherAppId = wxMpService.getWxMpConfigStorage().getAppId();

        log.info("接收到一个取消订阅事件:[{}]", wxMessage.toString());
        // 1、获取微信用户信息
        /*WxMpUser wxMpUser = wxMpService.getUserService().userInfo(wxMessage.getFromUser());
        if (null == wxMpUser) {
            log.warn("从微信公众号获取用户(FromUser)信息:[{}]失败.", wxMessage.getFromUser());
            return null;
        }
        log.info("根据 openId:[{}]获取到的微信用户信息:[{}]", wxMessage.getFromUser(), wxMpUser.toString());*/
        String openId = wxMessage.getFromUser();
        Integer type = 0;
        if (zhengzaiAppId.equals(otherAppId)) {// 正在服务号
            type = 1;
        } else {// 摩登服务号
            type = 2;
        }
        SweetWechatUsersVo sweetWechatUsers = redisUtils.getSweetWechatUsersOfOpenId(openId, type);
        if (null != sweetWechatUsers) {
            // 删除用户信息
            if (!sweetWechatUsers.getUnionId().isEmpty()) {
                redisUtils.delSweetWechatUsers(sweetWechatUsers.getUnionId(), openId, type);
                LinkedList<String> sqls = CollectionUtil.linkedListString();
                LinkedList<Object[]> sqlsDataA = CollectionUtil.linkedListObjectArr();
                sqls.add(SqlMapping.get("sweet_wechat_users.delete"));
                sqlsDataA.add(new Object[]{
                        sweetWechatUsers.getUnionId(), type
                });
                queueUtils.sendMsgByRedis(MQConst.SweetQueue.SWEET_WECHAT_USER_INSERT.getKey(),
                        SqlMapping.gets(sqls, sqlsDataA));
            }
        }
        return null;
    }
}
