package com.liquidnet.service.candy.dto;

import com.liquidnet.service.candy.entity.CandyCouponCode;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class CandyCouponCodeDto implements Serializable, Cloneable {
    private static final long serialVersionUID = -1303435376362293086L;
    private String ccode;
    private String couponId;
    private Integer state;
    //private String redeemUid;
    //private String redeemMobile;
    //private LocalDateTime redeemAt;
    private LocalDateTime redeemStart;
    private LocalDateTime redeemStop;
    //private LocalDateTime createdAt;
    //private LocalDateTime updatedAt;
    //private String comment;

    private static final CandyCouponCodeDto obj = new CandyCouponCodeDto();

    public static CandyCouponCodeDto getNew() {
        try {
            return (CandyCouponCodeDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new CandyCouponCodeDto();
        }
    }

    public CandyCouponCodeDto copy(CandyCouponCode source) {
        if (null == source) return this;
        this.setCcode(source.getCcode());
        this.setCouponId(source.getCouponId());
        this.setState(source.getState());
        this.setRedeemStart(source.getRedeemStart());
        this.setRedeemStop(source.getRedeemStop());
        return this;
    }
}
