package com.liquidnet.common.web.config;

import com.liquidnet.common.web.filter.GlobalLogTrackInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;

@Configuration
public class WebMvcConfig extends WebMvcConfigurationSupport {
    @Autowired
    GlobalLogTrackInterceptor globalLogTrackInterceptor;

    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler("/**").addResourceLocations(
                "classpath:/static/");
        registry.addResourceHandler("doc.html").addResourceLocations(
                "classpath:/META-INF/resources/");
        registry.addResourceHandler("/webjars/**").addResourceLocations(
                "classpath:/META-INF/resources/webjars/");
        registry.addResourceHandler("*.js").addResourceLocations(
                "/webapp/js/**");
        registry.addResourceHandler("*.css").addResourceLocations(
                "webapp/css/**");
        registry.addResourceHandler("*.img").addResourceLocations(
                "webapp/img/**");
        super.addResourceHandlers(registry);
    }

    @Override
    protected void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(globalLogTrackInterceptor).addPathPatterns("/**");
        super.addInterceptors(registry);
    }

//    @Bean
//    public FilterRegistrationBean domainCrossFilterBean(){
//        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
//        CrossDomainFilter filter = new CrossDomainFilter();
//        registrationBean.setFilter(filter);
//        registrationBean.addUrlPatterns("/*");
//        return registrationBean;
//    }
}
