package com.liquidnet.service.consumer.kylin.config;

import com.liquidnet.common.cache.redis.config.RedisStreamConfig;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.consumer.kylin.receiver.ConsumerKylinSqlOptOrderCloseRedisReceiver;
import lombok.var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

import java.time.Duration;

import static com.liquidnet.service.base.constant.MQConst.KylinQueue.SQL_ORDER_CLOSE;

@Configuration
public class ConsumerKylinSqlOptOrderCloseRedisStreamConfig extends RedisStreamConfig {
    @Autowired
    ConsumerKylinSqlOptOrderCloseRedisReceiver consumerKylinSqlOptOrderCloseRedisReceiver;

    /**
     * 订单关闭
     *
     * @param listenerContainer
     * @param t
     * @return
     */
    private Subscription receiveSqlOptOrderClose(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
        return listenerContainer.receiveAutoAck(Consumer.from(SQL_ORDER_CLOSE.getGroup(), getConsumerName(SQL_ORDER_CLOSE.name() + t)),
                StreamOffset.create(SQL_ORDER_CLOSE.getKey(), ReadOffset.lastConsumed()), consumerKylinSqlOptOrderCloseRedisReceiver
        );
    }

    /* —————————————————————————— ｜ —————————————————————————— ｜ —————————————————————————— */

    /* -------------------------------------------------------- ｜ 订单关闭 */

    @Bean
    public Subscription subscriptionSqlOptOrderClose0(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlOptOrderClose(listenerContainer, 0);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSqlOptOrderClose1(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlOptOrderClose(listenerContainer, 1);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSqlOptOrderClose2(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlOptOrderClose(listenerContainer, 2);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSqlOptOrderClose3(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlOptOrderClose(listenerContainer, 3);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSqlOptOrderClose4(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlOptOrderClose(listenerContainer, 4);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSqlOptOrderClose5(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlOptOrderClose(listenerContainer, 5);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSqlOptOrderClose6(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlOptOrderClose(listenerContainer, 6);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSqlOptOrderClose7(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlOptOrderClose(listenerContainer, 7);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSqlOptOrderClose8(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlOptOrderClose(listenerContainer, 8);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSqlOptOrderClose9(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlOptOrderClose(listenerContainer, 9);
        listenerContainer.start();
        return subscription;
    }

    /* -------------------------------------------------------- ｜  */
}
