package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@ApiModel(value = "GoblinUserDigitalArtworkInfoVo", description = "我的藏品详情")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinUserDigitalArtworkInfoVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 8903534983251413696L;
    @ApiModelProperty(position = 10, value = "藏品封面图片URL")
    private String coverPic;
    @ApiModelProperty(position = 11, value = "藏品名称")
    private String name;
    @ApiModelProperty(position = 12, value = "藏品副名称")
    private String subtitle;
    @ApiModelProperty(position = 13, value = "藏品素材类型[1-图片|2-视频|3-模型]")
    private String materialType;
    @ApiModelProperty(position = 14, value = "藏品素材URL")
    private String materialUrl;
    @ApiModelProperty(position = 15, value = "序列号")
    private Integer editionSn;
    @ApiModelProperty(position = 16, value = "藏品发行量")
    private Integer edition;
    @ApiModelProperty(position = 17, value = "藏品NFT ID")
    private String nftId;
    @ApiModelProperty(position = 17, value = "藏品交易HASH")
    private String tradingTxhash;
    @ApiModelProperty(position = 18, value = "藏品生成时间[yyyy-MM-dd HH:mm:ss]")
    private String generateTime;

    @ApiModelProperty(position = 19, value = "获得方式[1-购买|2-兑换|3-赠送|5-大美|6-转赠|31-空投赠送]")
    private Integer source;
    @ApiModelProperty(position = 20, value = "藏品状态，根据`unbox`区分盲盒来判断[0-生成中/未开启|1-已生成/已开启|2-生成失败/开启失败|5-待收取]")
    private Integer state;
    @ApiModelProperty(position = 21, value = "创作者")
    private String author;
    @ApiModelProperty(position = 22, value = "发行方")
    private String publisher;
    @ApiModelProperty(position = 23, value = "藏品详情")
    private String details;

    @ApiModelProperty(position = 24, value = "单品AR文件URL-iOS版")
    private String arUrlIos;
    @ApiModelProperty(position = 25, value = "单品AR文件URL-android版")
    private String arUrlAndroid;

    @ApiModelProperty(position = 26, value = "单品ID")
    private String skuId;
    @ApiModelProperty(position = 27, value = "展示预览图片URL[256]")
    private String skuWatchPic;
    @ApiModelProperty(position = 27, value = "区块链路由[zxinchain-至信链|xuper-百度超级链]")
    private String routeType;

    @ApiModelProperty(position = 28, value = "转赠状态[PENDING|SUCCESS]")
    private String transferState;
    @ApiModelProperty(position = 25, value = "转赠允许时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime transferAllowTime;
    @ApiModelProperty(position = 30, value = "系统当前时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime systime;

    @ApiModelProperty(position = 31, value = "受赠人信息")
    private String receiverUser;
    @ApiModelProperty(position = 32, value = "藏品转赠时间[yyyy-MM-dd HH:mm:ss]")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime transferTime;

    private static final GoblinUserDigitalArtworkInfoVo obj = new GoblinUserDigitalArtworkInfoVo();

    public static GoblinUserDigitalArtworkInfoVo getNew() {
        try {
            return (GoblinUserDigitalArtworkInfoVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinUserDigitalArtworkInfoVo();
        }
    }

    public GoblinUserDigitalArtworkInfoVo copy(GoblinUserDigitalArtworkVo source) {
        if (null == source) return this;
//        this.setName();
//        this.setSubtitle();
//        this.setMaterialType();
//        this.setMaterialUrl();
//        this.setEdition();
        this.setEditionSn(source.getEditionSn());
        this.setNftId(source.getNftId());
        this.setTradingTxhash(source.getTradingTxhash());
        this.setGenerateTime(source.getTradingAt());
        this.setSource(source.getSource());
        this.setState(source.getState());
        this.setAuthor(source.getAuthor());
        this.setPublisher(source.getPublisher());
//        this.setDetails();
        this.setSkuId(source.getSkuId());
        this.setTransferState(source.getTransferState());
        this.setReceiverUser(source.getReceiverUser());
        return this;
    }
}
