package com.liquidnet.service.adam.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.adam.constant.AdamRedisConst;
import com.liquidnet.service.adam.dto.vo.AdamMemberPriceVo;
import com.liquidnet.service.adam.dto.vo.AdamMemberVo;
import com.liquidnet.service.adam.entity.AdamMember;
import com.liquidnet.service.adam.mapper.AdamMemberMapper;
import com.liquidnet.service.adam.mapper.AdamMemberPriceMapper;
import com.liquidnet.service.adam.service.IAdamMemberService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

@Slf4j
@Service
public class AdamMemberServiceImpl extends ServiceImpl<AdamMemberMapper, AdamMember> implements IAdamMemberService {
    @Autowired
    AdamMemberMapper adamMemberMapper;
    @Autowired
    AdamMemberPriceMapper adamMemberPriceMapper;
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    MongoConverter mongoConverter;
    @Autowired
    RabbitTemplate rabbitTemplate;
    @Autowired
    RedisUtil redisUtil;

    // TODO: 2021/5/26 数据存取更正，不走MySql
    @Override
    public AdamMemberVo queryMemberInfo() {
        AdamMemberVo info = null;
        List<AdamMemberVo> adamMemberVoList = mongoTemplate.findAll(AdamMemberVo.class);
        int tag = 0;
        if (adamMemberVoList.size() > 0) {
            info = adamMemberVoList.get(0);
        } else  {
            AdamMember firstMember = adamMemberMapper.getFirstMember();
            if (null == firstMember) {
                return null;
            }
            info = new AdamMemberVo();
            BeanUtils.copyProperties(firstMember, info);
            tag = 1;
        }
        String memberId = info.getMemberId();
        List<AdamMemberPriceVo> memberPrice = new ArrayList<>();

        LinkedHashSet<String> hkeys = (LinkedHashSet<String>) redisUtil.hkeys(AdamRedisConst.INFO_MEMBERS_PRICE_INFO.concat(memberId));
        Iterator<String> priceIterator = hkeys.iterator();
        while(priceIterator.hasNext()){
            String key = priceIterator.next();
            AdamMemberPriceVo tempMemberPrice = (AdamMemberPriceVo) redisUtil.hget(AdamRedisConst.INFO_MEMBERS_PRICE_INFO.concat(memberId), key);
            memberPrice.add(tempMemberPrice);
        }

        info.setPriceVoList(memberPrice);
        if (1 == tag) {
            mongoTemplate.insert(info, AdamMemberVo.class.getSimpleName());
        }
        return info;
    }

//    @Override
//    public AdamMemberSimpleVo queryMemberSimpleVo() {
//        AdamMemberSimpleVo simpleVo = (AdamMemberSimpleVo) redisUtil.get(AdamRedisConst.INFO_MEMBERS);
//        if (null == simpleVo) {
//            List<AdamMemberSimpleVo> simpleVoList = mongoTemplate.findAll(AdamMemberSimpleVo.class, AdamMemberVo.class.getSimpleName());
//
//            simpleVo = CollectionUtils.isEmpty(simpleVoList) ? null : simpleVoList.get(0);
//
//            if (null != simpleVo) {
//                redisUtil.set(AdamRedisConst.INFO_MEMBERS, simpleVo);
//            }
//        }
//        return simpleVo;
//    }
}
