package com.liquidnet.service.galaxy.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.aop.annotation.ControllerLog;
import com.liquidnet.service.galaxy.dto.GalaxyUserRegisterReqDto;
import com.liquidnet.service.galaxy.dto.GalaxyUserRegisterRespDto;
import com.liquidnet.service.galaxy.service.IGalaxyUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyUserController
 * @Package com.liquidnet.service.galaxy.controller
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/11 12:11
 */
@Api(tags = "NFT-用户相关")
@RestController
@RequestMapping("user")
@Validated
@Slf4j
public class GalaxyUserController {
    @Autowired
    private IGalaxyUserService galaxyUserService;

    @ControllerLog(description = "NFT用户注册")
    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "NFT用户注册")
    @PostMapping(value = {"register"})
    public ResponseDto<GalaxyUserRegisterRespDto> register(@Valid @RequestBody GalaxyUserRegisterReqDto reqDto) {
        return galaxyUserService.userRegister(reqDto);
    }
}
