package com.liquidnet.common.mq.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * @author <a href="mailto:guo_xp@163.com">guoxinpeng</a>
 * @version 1.0 2016/11/23 13:50
 * @projectname new-pay
 * @packname com.liquidnet.service.config.mq
 */

@Data
@ConfigurationProperties(prefix = MQProperties.MQCONFIG_PREFIX)
@Component
public class MQProperties {
    public static final String MQCONFIG_PREFIX = "mq.config";

    /**
     * @desc 默认topic Exchange
     */
    private String defaultTopicExchange;
    /**
     * @desc 应答exchange
     */
    private String defaultDirectExchange;

    /**
     * @desc 数据推送key
     */
    private String dataSendRoutingKey;

    /**
     * @desc 数据推送监听队列
     */
    private String dataSendQueue;


    /**
     * @desc 推送签约信息key
     */
    private String overdueSigninfoRoutingKey;

    /**
     * @desc 签约信息推送监听队列
     */
    private String overdueSigninfoQueue;

    /**
     * @desc 还款推送key
     */
    private String overdueRepaymentRoutingKey;

    /**
     * @desc 还款推送监听队列
     */
    private String overdueRepaymentQueue;


    /**
     * @desc 逾期违约金额推送key
     */
    private String overduePenaltymoneyRoutingKey;

    /**
     * @desc 逾期违约金额推送监听队列
     */
    private String overduePenaltymoneyQueue;

    /**
     * @desc 三方数据推送key
     */
    private String loanRepaymentplanRoutingKey;
    /**
     * @desc 三方数据推送监听队列
     */
    private String loanRepaymentplanQueue;

    /**
     * @desc 接收冲账成功数据推送key
     */
    private String loanPushdataRoutingKey;
    /**
     * @desc 接收冲账成功数据推送监听队列
     */
    private String loanPushdataQueue;



    public static String getMqconfigPrefix() {
        return MQCONFIG_PREFIX;
    }

    public String getDefaultTopicExchange() {
        return defaultTopicExchange;
    }

    public void setDefaultTopicExchange(String defaultTopicExchange) {
        this.defaultTopicExchange = defaultTopicExchange;
    }

    public String getDefaultDirectExchange() {
        return defaultDirectExchange;
    }

    public void setDefaultDirectExchange(String defaultDirectExchange) {
        this.defaultDirectExchange = defaultDirectExchange;
    }

    public String getDataSendRoutingKey() {
        return dataSendRoutingKey;
    }

    public void setDataSendRoutingKey(String dataSendRoutingKey) {
        this.dataSendRoutingKey = dataSendRoutingKey;
    }

    public String getDataSendQueue() {
        return dataSendQueue;
    }

    public void setDataSendQueue(String dataSendQueue) {
        this.dataSendQueue = dataSendQueue;
    }

    public void setOverdueSigninfoRoutingKey(String overdueSigninfoRoutingKey) {
        this.overdueSigninfoRoutingKey = overdueSigninfoRoutingKey;
    }

    public String getOverdueSigninfoQueue() {
        return overdueSigninfoQueue;
    }

    public void setOverdueSigninfoQueue(String overdueSigninfoQueue) {
        this.overdueSigninfoQueue = overdueSigninfoQueue;
    }

    public String getOverdueSigninfoRoutingKey() {
        return overdueSigninfoRoutingKey;
    }

    public String getOverdueRepaymentRoutingKey() {
        return overdueRepaymentRoutingKey;
    }

    public void setOverdueRepaymentRoutingKey(String overdueRepaymentRoutingKey) {
        this.overdueRepaymentRoutingKey = overdueRepaymentRoutingKey;
    }

    public String getOverdueRepaymentQueue() {
        return overdueRepaymentQueue;
    }

    public void setOverdueRepaymentQueue(String overdueRepaymentQueue) {
        this.overdueRepaymentQueue = overdueRepaymentQueue;
    }

    public String getOverduePenaltymoneyRoutingKey() {
        return overduePenaltymoneyRoutingKey;
    }

    public void setOverduePenaltymoneyRoutingKey(String overduePenaltymoneyRoutingKey) {
        this.overduePenaltymoneyRoutingKey = overduePenaltymoneyRoutingKey;
    }

    public String getOverduePenaltymoneyQueue() {
        return overduePenaltymoneyQueue;
    }

    public void setOverduePenaltymoneyQueue(String overduePenaltymoneyQueue) {
        this.overduePenaltymoneyQueue = overduePenaltymoneyQueue;
    }

    public String getLoanRepaymentplanRoutingKey() {
        return loanRepaymentplanRoutingKey;
    }

    public void setLoanRepaymentplanRoutingKey(String loanRepaymentplanRoutingKey) {
        this.loanRepaymentplanRoutingKey = loanRepaymentplanRoutingKey;
    }

    public String getLoanRepaymentplanQueue() {
        return loanRepaymentplanQueue;
    }

    public void setLoanRepaymentplanQueue(String loanRepaymentplanQueue) {
        this.loanRepaymentplanQueue = loanRepaymentplanQueue;
    }


    public String getLoanPushdataRoutingKey() {
        return loanPushdataRoutingKey;
    }

    public void setLoanPushdataRoutingKey(String loanPushdataRoutingKey) {
        this.loanPushdataRoutingKey = loanPushdataRoutingKey;
    }

    public String getLoanPushdataQueue() {
        return loanPushdataQueue;
    }

    public void setLoanPushdataQueue(String loanPushdataQueue) {
        this.loanPushdataQueue = loanPushdataQueue;
    }
}
