package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "GoblinSelfGoodsCategoryVo", description = "平台分类信息")
@Data
public class GoblinSelfGoodsCategoryVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -2342407105969740471L;
    @ApiModelProperty(position = 10, value = "分类ID")
    private String cateId;
    @ApiModelProperty(position = 11, value = "分类名称")
    private String name;
    @ApiModelProperty(position = 12, value = "分类图标")
    private String icon;
    @ApiModelProperty(position = 13, value = "排序[数值越小,排序越前]")
    private Integer sort;
    @ApiModelProperty(position = 14, value = "分类层级[1-一级|2-二级|3-三级]")
    private String grade;
    @ApiModelProperty(position = 15, value = "分类父ID")
    private String catePid;
    @ApiModelProperty(position = 16, value = "是否需要填写ISBN[0-否|1-是]")
    private String neIsbn;

    public GoblinSelfGoodsCategoryVo setCateId(String cateId) {
        this.cateId = cateId;
        return this;
    }

    public GoblinSelfGoodsCategoryVo setName(String name) {
        this.name = name;
        return this;
    }

    public GoblinSelfGoodsCategoryVo setIcon(String icon) {
        this.icon = icon;
        return this;
    }

    public GoblinSelfGoodsCategoryVo setSort(Integer sort) {
        this.sort = sort;
        return this;
    }

    public GoblinSelfGoodsCategoryVo setGrade(String grade) {
        this.grade = grade;
        return this;
    }

    public GoblinSelfGoodsCategoryVo setCatePid(String catePid) {
        this.catePid = catePid;
        return this;
    }

    public GoblinSelfGoodsCategoryVo setNeIsbn(String neIsbn) {
        this.neIsbn = neIsbn;
        return this;
    }

    private static final GoblinSelfGoodsCategoryVo obj = new GoblinSelfGoodsCategoryVo();
    public static GoblinSelfGoodsCategoryVo getNew() {
        try {
            return (GoblinSelfGoodsCategoryVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinSelfGoodsCategoryVo();
        }
    }
}
