package com.liquidnet.client.admin.web.controller.zhengzai.kylin;

import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.client.admin.common.utils.ShiroUtils;
import com.liquidnet.client.admin.common.utils.poi.ExcelUtil;
import com.liquidnet.client.admin.zhengzai.kylin.dto.OrderOutLineVo;
import com.liquidnet.client.admin.zhengzai.kylin.service.IImportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

@Controller
@RequestMapping("/import")
public class ImportController {

    private String prefix = "zhengzai/kylin/performances/orderImport";

    @Autowired
    IImportService iImportService;

    /**
     * 下载模板
     */
    @GetMapping("/template/OrderOutLine")
    @ResponseBody
    public AjaxResult importTemplateOrderOutLine() {
        ExcelUtil<OrderOutLineVo> util = new ExcelUtil(OrderOutLineVo.class);
        return util.importTemplateExcel("订单导入数据");
    }


    /**
     * 导入
     */
    @PostMapping("/OrderOutLine/{performancesId}")
    @ResponseBody
    public AjaxResult importOrderOutLine(@PathVariable("performancesId") String performancesId, MultipartFile file, boolean updateSupport) throws Exception {
        ExcelUtil<OrderOutLineVo> util = new ExcelUtil(OrderOutLineVo.class);
        List<OrderOutLineVo> orderOutLineVoList = util.importExcel(file.getInputStream());
//        String operName = ShiroUtils.getSysUser().getLoginName();
        String message = iImportService.importOrderOutLine(performancesId, orderOutLineVoList, updateSupport, file.getName());
        return AjaxResult.success(message);
    }

    /**
     * 跳转导入详情
     */
    @GetMapping("OrderOutLine/detailsList/{id}")
    @ResponseBody
    public String detailsList(@PathVariable("id") String importId, ModelMap mmap) {
        mmap.put("importId", importId);
        return prefix + "/details";
    }

    /**
     * 导入纪录
     */
    @GetMapping("/OrderOutLine/details/{importId}")
    @ResponseBody
    public TableDataInfo importOrderOutLine(@PathVariable("importId") String importId) {
        PageInfo<OrderOutLineVo> result = iImportService.getImportDetails(importId);
        TableDataInfo rspData = new TableDataInfo();
        rspData.setCode(0);
        rspData.setRows(result.getList());
        rspData.setTotal(result.getTotal());
        return rspData;
    }
}
