package com.liquidnet.service.goblin.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 商品单品
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinGoodsSku implements Serializable {

    private static final long serialVersionUID = 1L;

    private String skuId;

    /**
     * 商品id
     */
    private String spuId;

    /**
     * 单品的编号
     */
    private String skuNo;

    /**
     * 商品类型[0-常规|1-数字藏品]
     */
    private Integer skuType;

    /**
     * 单品的名称
     */
    private String name;

    /**
     * 单品的副标题
     */
    private String subtitle;

    /**
     * 简介
     */
    private String intro;

    /**
     * 详情
     */
    private String details;

    /**
     * 单品销售价-原价
     */
    private BigDecimal sellPrice;

    /**
     * 单品默认图片的url
     */
    private String skuPic;

    /**
     * ISBN，针对CD/图书等
     */
    private String skuIsbn;

    /**
     * 展示文件URL
     */
    private String skuWatch;

    /**
     * 素材原始文件URL
     */
    private String materialOriginalUrl;

    /**
     * 总库存
     */
    private Integer stock;

    /**
     * 单品库存
     */
    private Integer skuStock;

    /**
     * 兑换库存
     */
    private Integer giftStock;

    /**
     * 预警库存
     */
    private Integer warningStock;

    /**
     * 单品现价
     */
    private BigDecimal price;

    /**
     * 单品会员价格
     */
    private BigDecimal priceMember;

    /**
     * 单品的重量
     */
    private BigDecimal weight;

    /**
     * 购买限制[0-全部用户|1-仅会员|2-指定用户]
     */
    private String buyFactor;

    /**
     * 购买限制人员名单[购买限制为2-指定用户时必填]
     */
    private String buyRoster;

    /**
     * 限量[0-无限制|X:限购数量]
     */
    private Integer buyLimit;

    /**
     * 商品的店铺id，如果是平台的则为0
     */
    private String storeId;

    /**
     * 上架处理方式[1-等待手动上架|2-直接上架售卖|3-预约定时上架]
     */
    private String shelvesHandle;

    /**
     * 预约上架时间[上架处理方式为3-预约定时上架时需要指定]
     */
    private LocalDateTime shelvesTime;

    /**
     * 开售时间
     */
    private LocalDateTime saleStartAt;

    /**
     * 停售时间
     */
    private LocalDateTime saleStopAt;

    /**
     * 单品有效期
     */
    private LocalDateTime skuValidity;

    /**
     * 是否是虚拟商品[0-否|1-是]
     */
    private String virtualFlg;

    /**
     * 审核状态[0-初始编辑|1-审核中|2-审核不通过|3-审核通过]
     */
    private String status;

    /**
     * 审核拒绝原因
     */
    private String reason;

    /**
     * 单品上架状态[0-待上架|1-下架|2-违规|3-上架]
     */
    private String shelvesStatus;

    /**
     * 自定义展示[0-默认展示|1-隐藏不可购买]
     */
    private String skuAppear;

    /**
     * 是否盲盒[0-否|1-是]
     */
    private Integer unbox;

    /**
     * 盲盒命中率
     */
    private String hitRatio;

    /**
     * 盲盒开启时间
     */
    private LocalDateTime openingTime;

    /**
     * 盲盒开启时限[单位秒]
     */
    private Integer openingLimit;

    /**
     * NFT路由
     */
    private String routeType;

    /**
     * NFT预览图URL
     */
    private String displayUrl;

    /**
     * NFT素材访问URL
     */
    private String materialAccessUrl;

    /**
     * NFT系列ID
     */
    private String seriesId;

    /**
     * 删除标记[0-未删除|1删除]
     */
    private String delFlg;

    /**
     * 上架时间
     */
    private LocalDateTime shelvesAt;

    private String createdBy;

    private LocalDateTime createdAt;

    private String updatedBy;

    private LocalDateTime updatedAt;

    private String deletedBy;

    private LocalDateTime deletedAt;

    /**
     * 物流模版id
     */
    private String logisticsTemplate;

    private String comment;


}
