use dev_ln_scene;
# -- >>------------------------------------------------------------------------------------
alter table adam_real_name add node tinyint default 2 not null comment '认证节点[2-二要素|3-三要素]' after type;

alter table goblin_goods add spu_type tinyint default 0 not null comment '商品类型[0-常规|1-数字藏品]' after spu_no;
alter table goblin_goods add attention varchar(256) null comment '注意事项' after details;
alter table goblin_goods add sale_start_at datetime null comment '开售时间' after shelves_time;
alter table goblin_goods add sale_stop_at datetime null comment '停售时间' after sale_start_at;
alter table goblin_goods add author varchar(100) null comment '创作者' after spu_appear;
alter table goblin_goods add publisher varchar(100) null comment '发行方' after author;
# alter table goblin_goods add has_box tinyint default 0 null comment '存在盲盒[0-否|1-是]' after spu_appear;

alter table goblin_goods_sku add sku_type tinyint default 0 not null comment '商品类型[0-常规|1-数字藏品]' after sku_no;
alter table goblin_goods_sku add intro varchar(256) null comment '简介' after subtitle;
alter table goblin_goods_sku add details text null comment '详情' after intro;
alter table goblin_goods_sku add sku_watch varchar(256) null comment '展示文件URL' after sku_isbn;
alter table goblin_goods_sku add material_original_url varchar(256) null comment '素材原始文件URL' after sku_watch;

alter table goblin_goods_sku add gift_stock int null comment '兑换库存' after sku_stock;
alter table goblin_goods_sku add shelves_handle char default '1' comment '上架处理方式[1-等待手动上架|2-直接上架售卖|3-预约定时上架]' after store_id;
alter table goblin_goods_sku add shelves_time datetime null comment '预约上架时间[上架处理方式为3-预约定时上架时需要指定]' after shelves_handle;
alter table goblin_goods_sku add sale_start_at datetime null comment '开售时间' after shelves_time;
alter table goblin_goods_sku add sale_stop_at datetime null comment '停售时间' after sale_start_at;

alter table goblin_goods_sku add unbox tinyint default 0 null comment '是否盲盒[0-否|1-是]' after sku_appear;
alter table goblin_goods_sku add hit_ratio varchar(10) null comment '盲盒命中率' after unbox;
alter table goblin_goods_sku add opening_time datetime null comment '盲盒开启时间' after hit_ratio;
alter table goblin_goods_sku add opening_limit int default 0 comment '盲盒开启时限[单位秒]' after opening_time;
alter table goblin_goods_sku add route_type varchar(20) null comment 'NFT路由' after opening_limit;
alter table goblin_goods_sku add display_url varchar(256) null comment 'NFT预览图URL' after route_type;
alter table goblin_goods_sku add material_access_url varchar(256) null comment 'NFT素材访问URL' after display_url;
alter table goblin_goods_sku add series_id varchar(256) null comment 'NFT系列ID' after material_access_url;
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_digital_artwork;
create table goblin_digital_artwork
(
    mid        bigint auto_increment primary key,
    order_id   varchar(64)  not null comment '藏品订单号',
    uid        varchar(64)  not null comment '用户UID',
    sku_id     varchar(64)  not null comment '单品ID',

    opening_at datetime     null comment '盲盒开启时间',
    state      char default '0' comment '藏品状态[0-生成中/未开启|1-已生成/已开启|2-生成失败/开启失败]',

    edition_sn int          null comment '序列号',
    nft_id     varchar(256) null comment '发行标识',
    release_at datetime     null comment '发行时间',
    trading_at datetime     null comment '交易时间',

    del_flg    char default '0' comment '删除标记[0-未删除|1-删除]',
    created_at datetime     not null,
    updated_at datetime     null,
    deleted_at datetime     null,
    comment    varchar(500)
) engine = InnoDB comment '数字藏品信息';
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_goods_sku_excode;
create table goblin_goods_sku_excode
(
    mid        bigint auto_increment primary key,
    sku_id     varchar(64) not null comment '单品ID',
    num        int comment '生成数量',
    type       tinyint comment '兑换码类型[0-普通商品|1-数字藏品|2-数字藏品盲盒]',

    code       varchar(64) not null comment '单品兑换码',
    state      tinyint default 0 comment '兑换码状态[0-未兑换|1-已兑换|10-用作生成模版]',
    start_at   datetime    null comment '开始时间',
    stop_at    datetime    null comment '截止时间',

    redeem_uid varchar(64) comment '兑换用户UID',
    redeem_for varchar(128) comment '兑换内容描述',
    redeem_at  datetime comment '兑换时间',

    operator   varchar(64),
    created_at datetime    not null,
    updated_at datetime    null,
    deleted_at datetime    null,
    comment    varchar(500)
) engine = InnoDB comment '单品兑换码';

create index idx_ggse_sku_id on goblin_goods_sku_excode (sku_id);
# -- >>------------------------------------------------------------------------------------

DROP TABLE IF EXISTS goblin_nft_order;
CREATE TABLE goblin_nft_order
(
    mid                  BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    order_id             VARCHAR(64)      NOT NULL DEFAULT '' COMMENT '订单id',
    spu_id               VARCHAR(64)      NOT NULL DEFAULT '' COMMENT '商品id',
    sku_id               VARCHAR(64)      NOT NULL DEFAULT '' COMMENT '款式id',
    num                  INT UNSIGNED     NOT NULL DEFAULT 0 COMMENT '数量',
    store_id             VARCHAR(64)      NOT NULL DEFAULT '' COMMENT '店铺id',
    store_name           VARCHAR(255)     NOT NULL DEFAULT '' COMMENT '商铺名称',
    order_code           VARCHAR(64)      NOT NULL DEFAULT '' COMMENT '订单号',
    user_id              VARCHAR(64)      NOT NULL DEFAULT '' COMMENT '用户id',
    user_name            VARCHAR(50)      NOT NULL DEFAULT '' COMMENT '用户昵称',
    user_mobile          VARCHAR(30)      NOT NULL DEFAULT '' COMMENT '用户手机号',
    is_member            TINYINT UNSIGNED NOT NULL DEFAULT 0 COMMENT '是否会员',
    price_total          DECIMAL(8, 2)    NOT NULL DEFAULT 0 COMMENT '应付金额',
    price_coupon         DECIMAL(8, 2)    NOT NULL DEFAULT 0 COMMENT '券优惠金额',
    store_price_coupon   DECIMAL(8, 2)    NOT NULL DEFAULT 0 COMMENT '商铺券优惠金额',
    price_red_envelope   DECIMAL(8, 2)    NOT NULL DEFAULT 0 COMMENT '红包优惠金额',
    price_voucher        DECIMAL(8, 2)    NOT NULL DEFAULT 0 COMMENT '总优惠价格',
    price_actual         DECIMAL(8, 2)    NOT NULL DEFAULT 0 COMMENT '实付金额',
    ucoupon_id           VARCHAR(64)      NOT NULL DEFAULT '' COMMENT '券id',
    store_coupon_id      VARCHAR(255)     NOT NULL DEFAULT '' COMMENT '商铺券id',
    red_envelope_code    VARCHAR(64)      NOT NULL DEFAULT '' COMMENT '红包code',
    status               TINYINT UNSIGNED NOT NULL DEFAULT 0 COMMENT '订单状态 0-待付款(用户刚下单)|1-已付款|2-已取消(未付款取消订单)|3-已退款(超时支付)',
    source               VARCHAR(32)      NOT NULL DEFAULT '' COMMENT '订单来源 app|h5|applet',
    order_type           TINYINT UNSIGNED NOT NULL DEFAULT 0 COMMENT '订单类型 0-购买订单|1-兑换订单|2-演出赠送订单',
    pay_time             DATETIME         NULL     DEFAULT NULL COMMENT '支付时间',
    pay_code             VARCHAR(64)      NOT NULL DEFAULT '' COMMENT '支付单号',
    pay_type             VARCHAR(32)      NOT NULL DEFAULT '' COMMENT '支付类型 wepay-微信支付|alipay-阿里支付|douyinpay-抖音支付|unionpay-银联支付',
    device_from          VARCHAR(32)      NOT NULL DEFAULT '' COMMENT '支付类型来源[wap|js]',
    payment_type         VARCHAR(32)      NOT NULL DEFAULT '' COMMENT '支付中心返回实际支付类型',
    payment_id           VARCHAR(128)     NOT NULL DEFAULT '' COMMENT '支付中心返回支付id',
    pay_store_id         VARCHAR(64)      NOT NULL DEFAULT '' COMMENT '钱到了哪个支付平台  平台的订单id为''',
    pay_countdown_minute TINYINT UNSIGNED          DEFAULT 5 COMMENT '订单过期时间(分钟)',
    cancel_reason        VARCHAR(256)     NOT NULL DEFAULT '' COMMENT '取消原因',
    cancel_time          DATETIME         NULL     DEFAULT NULL COMMENT '取消时间',
    version              VARCHAR(32)      NOT NULL DEFAULT '' COMMENT '版本号',
    ip_address           VARCHAR(32)               DEFAULT '' COMMENT 'ip地址',
    area                 VARCHAR(32)               DEFAULT '' COMMENT 'ip地域全名称',
    area_province        VARCHAR(32)               DEFAULT '' COMMENT 'ip地域省',
    area_city            VARCHAR(32)               DEFAULT '' COMMENT 'ip地域市',
    area_county          VARCHAR(32)               DEFAULT '' COMMENT 'ip地域县',
    created_at           DATETIME         NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    updated_at           DATETIME         NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    KEY `nft_order_id_index` (`order_id`),
    KEY `nft_order_code_index` (`order_code`),
    KEY `nft_store_id_index` (`store_id`),
    KEY `nft_user_id_index` (`user_id`),
    KEY `nft_ucoupon_id_index` (`ucoupon_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT 'NFT订单表';
# -- >>------------------------------------------------------------------------------------
DROP TABLE IF EXISTS goblin_nft_order_refund;
CREATE TABLE goblin_nft_order_refund
(
    mid             BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    order_refund_id VARCHAR(64)   NOT NULL DEFAULT '' COMMENT '订单退单表id',
    refund_code     VARCHAR(64)   NOT NULL DEFAULT '' COMMENT '退款单号',
    order_id        VARCHAR(64)   NOT NULL DEFAULT '' COMMENT '订单id',
    order_code      VARCHAR(64)   NOT NULL DEFAULT '' COMMENT '订单编号',
    store_id        VARCHAR(64)   NOT NULL DEFAULT '' COMMENT '商铺id',
    user_id         VARCHAR(64)   NOT NULL DEFAULT '' COMMENT '用户id',
    sku_id_nums     VARCHAR(255)  NOT NULL DEFAULT '' COMMENT '退货的单品ID多个用,分开  退款的时候不需要，因为退款只能整单退1001-1,1002-3 表示单品id为1001 的单品退货1件 单品id为1002的单品退货3件',
    real_back_price DECIMAL(8, 2) NOT NULL DEFAULT 0 COMMENT '退货时候实际退款金额',
    status          INT UNSIGNED  NOT NULL DEFAULT 0 COMMENT '退款状态 1申请|2退款成功|3退款失败',
    refund_at       DATETIME      NULL     DEFAULT NULL COMMENT '退款时间',
    error_reason    VARCHAR(255)  NOT NULL DEFAULT '' COMMENT '退款失败原因',
    created_at      DATETIME      NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    updated_at      DATETIME      NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    KEY `nft_refund__index` (`order_refund_id`),
    KEY `nft_refund_refund_code_index` (`refund_code`),
    KEY `nft_refund_order_id_index` (`order_id`),
    KEY `nft_refund_order_code_index` (`order_code`),
    KEY `nft_refund_store_id_index` (`store_id`),
    KEY `nft_refund_user_id_index` (`user_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT 'NFT订单退款表';
# -- >>------------------------------------------------------------------------------------
# -- >>------------------------------------------------------------------------------------
# -- >>------------------------------------------------------------------------------------