package com.liquidnet.service.merchant.service.impl;

import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.merchant.constant.MerchantPermissionConst;
import com.liquidnet.service.merchant.dto.vo.MerchantAuthorizationPermissionsVo;
import com.liquidnet.service.merchant.dto.vo.MerchantAuthorizationRecordsVo;
import com.liquidnet.service.merchant.service.IMerchantAuthorizationRecordsService;
import com.liquidnet.service.merchant.service.MerchantMongoService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

@Slf4j
@Service
public class MerchantAuthorizationRecordsServiceImpl implements IMerchantAuthorizationRecordsService {

    @Autowired
    MerchantMongoService merchantMongoService;

    @Override
    public void performanceCheckerAdd(String cuid, String performanceId, String uid, String mobile, String name, boolean statistics) {
        LocalDateTime now = LocalDateTime.now();

        MerchantAuthorizationRecordsVo checkerAuthorizationRecordsVo = MerchantAuthorizationRecordsVo.getNew();
        checkerAuthorizationRecordsVo.setAuthorizationRecordId(IDGenerator.nextSnowId());
        checkerAuthorizationRecordsVo.setPerformanceId(performanceId);
        checkerAuthorizationRecordsVo.setUidRole("checker");
        checkerAuthorizationRecordsVo.setUid(uid);
        checkerAuthorizationRecordsVo.setMobile(mobile);
        checkerAuthorizationRecordsVo.setName(name);
        checkerAuthorizationRecordsVo.setCuid("cuid");
//        checkerAuthorizationRecordsVo.setCuidRole("fielder");
        checkerAuthorizationRecordsVo.setCreatedAt(now);

        // 验票员 授权权限
        String[] checkerPermissionIds = {
                MerchantPermissionConst.PerformancePermission.CHECK.getId()
        };
        // 验票员 授权权限 entity vo
        ArrayList<MerchantAuthorizationPermissionsVo> checkerAuthorizationPermissionsVos = new ArrayList<>();
        for (String permissionId : checkerPermissionIds) {
            MerchantAuthorizationPermissionsVo checkerAuthorizationPermissionsVo = MerchantAuthorizationPermissionsVo.getNew();
            checkerAuthorizationPermissionsVo.setAuthorizationPermissionId(IDGenerator.nextSnowId());
            checkerAuthorizationPermissionsVo.setAuthorizationRecordId(checkerAuthorizationRecordsVo.getAuthorizationRecordId());
            checkerAuthorizationPermissionsVo.setPermissionId(permissionId);
            checkerAuthorizationPermissionsVo.setStartTime(now);
            checkerAuthorizationPermissionsVo.setEndTime(now.plusYears(99));
            checkerAuthorizationPermissionsVo.setCreatedAt(now);

            checkerAuthorizationPermissionsVos.add(checkerAuthorizationPermissionsVo);
        }
        checkerAuthorizationRecordsVo.setPermissionsVos(checkerAuthorizationPermissionsVos);
    }

    @Override
    public void performanceCheckerDel(String cuid, String performanceId, String uid) {

    }

    @Override
    public List<MerchantAuthorizationRecordsVo> performanceCheckers(String cuid, String performanceId) {
        List<MerchantAuthorizationRecordsVo> authorizationRecordsVos = merchantMongoService.getCheckersAuthorizationRecordsVosByCuid(cuid, performanceId);
        return authorizationRecordsVos;
    }
}
