package com.liquidnet.service.adam.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@ApiModel(value = "AdamMemberOrderParam", description = "入场人响应")
@Data
public class AdamMemberOrderParam implements Serializable {
    private static final long serialVersionUID = 3219448286221952517L;
    @ApiModelProperty(position = 10, required = true, value = "会员ID[50]", example = "62960077673504768")
    private String memberId;
    @ApiModelProperty(position = 11, required = true, value = "购买方式:0-购买会员,1-购买会员码", example = "0")
    private Integer mode;
    @ApiModelProperty(position = 12, required = true, value = "应付金额", example = "0")
    private BigDecimal price;
    @ApiModelProperty(position = 13, required = true, value = "实付金额", example = "0")
    private BigDecimal pricePaid;
    @ApiModelProperty(position = 14, required = true, value = "会员价格ID", example = "0")
    private String memberPriceId;
    @ApiModelProperty(position = 15, required = true, value = "用户生日", example = "0")
    private String birthday;
    @ApiModelProperty(position = 16, required = true, value = "支付方式:ALIPAY,WEPAY,WAPALIPAY,WAPWEPAY,JSWEPAY,APPLETWEPAY,APPIAP")
    private String payChannel;
    @ApiModelProperty(position = 17, required = true, value = "支付用的AuthCode")
    private String authCode;
    @ApiModelProperty(position = 18, required = true, value = "支付用的productId")
    private String productId;
    @ApiModelProperty(position = 19, required = true, value = "支付用的openId")
    private String openId;
    @ApiModelProperty(position = 20, required = false, value = "姓名")
    private String name;
    @ApiModelProperty(position = 21, required = false, value = "身份证件号")
    private String idCard;
    @ApiModelProperty(position = 22, required = false, value = "用户ID", example = "1")
    private String uid;
    @ApiModelProperty(position = 23, required = false, value = "IP地址")
    private String clientIp;
    @ApiModelProperty(position = 24, required = false, value = "版本")
    private String version;
    @ApiModelProperty(position = 25, required = false, value = "来源")
    private String source;
}
