package com.liquidnet.service.adam.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.dto.vo.AdamMemberVo;
import com.liquidnet.service.adam.service.IAdamMemberService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "会员信息")
@Slf4j
@RestController
@RequestMapping("/member")
public class AdamMemberController {

    @Autowired
    IAdamMemberService adamMemberService;

    @ApiOperationSupport(order = 0)
    @ApiOperation(value = "会员信息")
    @GetMapping("info")
    public ResponseDto<Object> query() {
        AdamMemberVo info = adamMemberService.queryMemberInfo();
        return ResponseDto.success(info);
    }
}
