package com.liquidnet.service.kylin.controller;


import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.kylin.dto.param.PerformanceCreateParam;
import com.liquidnet.service.kylin.service.impl.KylinPerformancesServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.List;

/**
 * <p>
 * 演出 前端控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-11
 */
@Api(tags = "前端-演出")
@RestController
@RequestMapping("performance")
public class KylinPerformancesController {

    @Autowired
    private KylinPerformancesServiceImpl kylinPerformancesService;

    @GetMapping("localList")
    @ApiOperation("本地演出列表")
    public ResponseDto<HashMap<String, Object>> localList(
            @RequestParam(value = "title", defaultValue = "") String title, //演出名称
            @RequestParam(value = "cityId", defaultValue = "") String cityId, //省份id
            @RequestParam(value = "type", defaultValue = "") Integer type, //演出类型
            @RequestParam(value = "page", defaultValue = "1") Integer page,
            @RequestParam(value = "size", defaultValue = "10") Integer size,

            // 排序
            @RequestParam(value = "SortType", defaultValue = "1") Integer SortType // 1时间正序 2时间倒序
    ) {
        HashMap<String, Object> result = kylinPerformancesService.localList(title, cityId, type, page, size, SortType);
        if (result.size() > 0) {
            return ResponseDto.success(result);
        } else {
            return ResponseDto.failure("获取本地演出列表失败");
        }
    }

}
