package com.liquidnet.service.sweet.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 微信用户信息关联表
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-11-04
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SweetWechatUsersRelation implements Serializable {

    private static final long serialVersionUID = 1805653079540343937L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * wechat_relation_id
     */
    private String wechatRelationId;

    /**
     * unionId
     */
    private String unionId;

    /**
     * adam用户id
     */
    private String userId;

    /**
     * adam用户手机号
     */
    private String userPhone;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;


}
