package com.liquidnet.client.admin.web.controller.zhengzai.kylin;

import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.zhengzai.kylin.service.impl.PerformancesExpressServiceImpl;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dao.PerformanceExpressPerformanceListAdminDao;
import com.liquidnet.service.kylin.dao.PerformanceExpressPerformanceOrderListAdminDao;
import com.liquidnet.service.kylin.dto.param.PerformanceExpressSearchAdminParam;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 演出快递
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-06-21
 */

@Controller
@RequestMapping("/kylin/performancesExpress")
public class PerformancesExpressController extends BaseController {

    private String prefix = "zhengzai/kylin/performancesExpress";

    /*@Value("${liquidnet.shunfeng.url}")
    public String url;
    @Value("${liquidnet.shunfeng.sk}")
    private String sk;
    @Value("${liquidnet.shunfeng.appid}")
    private String appid;*/

    @Autowired
    private PerformancesExpressServiceImpl performancesExpressServiceImpl;

    /**
     * 查询演出列表
     */
    @RequiresPermissions("kylin:performancesExpress:view")
    @GetMapping()
    public String performancesListView() {
        return prefix + "/performancesList";
    }

    @RequiresPermissions("kylin:performancesExpress:performancesList")
    @PostMapping("/performancesList")
    @ResponseBody
    public TableDataInfo performancesList(PerformanceExpressSearchAdminParam performanceExpressSearchAdminParam) {
        List<PerformanceExpressPerformanceListAdminDao> result = performancesExpressServiceImpl.getPerformancesList(performanceExpressSearchAdminParam);
        return getDataTable(result);
    }

    /**
     * 查询演出订单列表
     */
    @RequiresPermissions("kylin:performancesExpress:performanceOrderList")
    @GetMapping("performanceOrderList/{id}")
    public String performanceOrderListView(@PathVariable("id") String id, ModelMap mmap) {
        mmap.put("performancesId", id);
        return prefix + "/performanceOrderList";
    }

    @RequiresPermissions("kylin:performancesExpress:performanceOrderList")
    @PostMapping("/performanceOrderList")
    @ResponseBody
    public TableDataInfo performanceOrderList(PerformanceExpressSearchAdminParam performanceExpressSearchAdminParam) {
        List<PerformanceExpressPerformanceOrderListAdminDao> result = performancesExpressServiceImpl.getPerformancesOrderList(performanceExpressSearchAdminParam);
        return getDataTable(result);
    }

    /**
     * 下单
     */
    @RequiresPermissions("kylin:performancesExpress:placeOrder")
    @PostMapping("/placeOrder")
    @ResponseBody
    public AjaxResult placeOrder(PerformanceExpressSearchAdminParam performanceExpressSearchAdminParam) {
        ResponseDto res = performancesExpressServiceImpl.placeOrder(performanceExpressSearchAdminParam);
        try {
            if (res.isSuccess()) {
                return success();
            } else {
                return error(res.getMessage());
            }
        } catch (Exception e) {
            return error(e.getMessage());
        }
    }

}
