package com.liquidnet.service.account.funding.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * FundingAccountInfo.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/10/22
 */
@ApiModel(value = "FundingAccountInfoVo", description = "Funding account details")
public class FundingAccountInfo implements java.io.Serializable {
    private static final long serialVersionUID = -7352805462412115521L;
    @ApiModelProperty(position = 11, required = true, value = "Funding account number [32]")
    private String accNo;
    @ApiModelProperty(position = 12, required = true, value = "Funding account balance [20,6]")
    private BigDecimal balance;
    @ApiModelProperty(position = 13, required = true, value = "Funding account group ID [32]")
    private String accGroupId;

    public String getAccNo() {
        return accNo;
    }

    public void setAccNo(String accNo) {
        this.accNo = accNo;
    }

    public BigDecimal getBalance() {
        return balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public String getAccGroupId() {
        accGroupId = accNo.substring(0, accNo.length() - 3);
        return accGroupId;
    }

    public void setAccGroupId(String accGroupId) {
        this.accGroupId = accGroupId;
    }
}
