package com.liquidnet.service.executor.main.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.feign.reconciliation.task.FeignTaskReconAccountCheckClient;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import com.xxl.job.core.log.XxlJobLogger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description:
 * @class: ExecutorReconciliationHandler
 * @Package com.liquidnet.service.executor.main.handler
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/12/14 5:16 下午
 */
@Component
public class ExecutorReconciliationHandler {
    @Autowired
    private FeignTaskReconAccountCheckClient feignTaskReconAccountCheckClient;

    @XxlJob(value = "sev-recon:accountCheckTask")
    public ReturnT<String> accountCheckTask(String param) {
        XxlJobLogger.log("start:liquidnet.accountCheckTask:[{}]", param);

        String bankChannel = null;
        String billDate = null;
        if (!StringUtils.isEmpty(param)) {
            JSONObject jsonParam = JSON.parseObject(param);
            bankChannel = jsonParam.getString("bankChannel");
            billDate = jsonParam.getString("billDate");
        }
        feignTaskReconAccountCheckClient.accountCheck(bankChannel,billDate);
        XxlJobLogger.log("end:liquidnet.accountCheckTask:[{}]", JSON.toJSONString(ResponseDto.success()));
        return ReturnT.SUCCESS;
    }
}
