package com.liquidnet.client.admin.zhengzai.adam.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.zhengzai.adam.service.IAdamMemberRightsAdminService;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.adam.dto.admin.AdamMemberRightsBuildParam;
import com.liquidnet.service.adam.entity.AdamMemberRights;
import com.liquidnet.service.adam.mapper.AdamMemberRightsMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdamMemberRightsAdminServiceImpl extends ServiceImpl<AdamMemberRightsMapper, AdamMemberRights> implements IAdamMemberRightsAdminService {
    @Autowired
    private AdamMemberRightsMapper adamMemberRightsMapper;

    @Override
    public boolean edit(AdamMemberRightsBuildParam param) {
        String mrightsId = param.getMrightsId();

        boolean saveOrUpadateRst;
        AdamMemberRights saveOrUpdateInfo = new AdamMemberRights();
        if (StringUtils.isEmpty(mrightsId)) {
            saveOrUpdateInfo.setMrightsId(IDGenerator.nextMilliId2());
            saveOrUpdateInfo.setMemberId(param.getMemberId());
            saveOrUpdateInfo.setState(1);

            saveOrUpdateInfo.setSeqNo(param.getSeqNo());
            saveOrUpdateInfo.setTitle(param.getTitle());
            saveOrUpdateInfo.setSubTitle(param.getSubTitle());
            saveOrUpdateInfo.setLabel(param.getLabel());
            saveOrUpdateInfo.setCover(param.getCover());
            saveOrUpdateInfo.setDetail(param.getDetail());

            saveOrUpadateRst = adamMemberRightsMapper.insert(saveOrUpdateInfo) > 0;
        } else {
            LambdaUpdateWrapper<AdamMemberRights> updateWrapper = Wrappers.lambdaUpdate(AdamMemberRights.class).eq(AdamMemberRights::getState, 1)
                    .eq(AdamMemberRights::getMemberId, param.getMemberId())
                    .eq(AdamMemberRights::getMrightsId, param.getMrightsId());

            saveOrUpdateInfo.setSeqNo(param.getSeqNo());
            saveOrUpdateInfo.setTitle(param.getTitle());
            saveOrUpdateInfo.setSubTitle(param.getSubTitle());
            saveOrUpdateInfo.setLabel(param.getLabel());
            saveOrUpdateInfo.setCover(param.getCover());
            saveOrUpdateInfo.setDetail(param.getDetail());

            saveOrUpadateRst = adamMemberRightsMapper.update(saveOrUpdateInfo, updateWrapper) > 0;
        }
        return saveOrUpadateRst;
    }
}
