package com.liquidnet.client.admin.zhengzai.candy.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.zhengzai.candy.service.ICandyCouponRuleAdminService;
import com.liquidnet.client.admin.zhengzai.candy.service.ICandyMgtCouponAdminService;
import com.liquidnet.common.exception.LiquidnetServiceException;
import com.liquidnet.service.candy.dto.admin.CandyMgtCouponInfoDto;
import com.liquidnet.service.candy.dto.admin.CandyMgtCouponListParam;
import com.liquidnet.service.candy.dto.admin.CandyMgtCouponMemberDto;
import com.liquidnet.service.candy.entity.CandyCoupon;
import com.liquidnet.service.candy.entity.CandyCouponRule;
import com.liquidnet.service.candy.entity.CandyMgtCoupon;
import com.liquidnet.service.candy.mapper.CandyCouponMapper;
import com.liquidnet.service.candy.mapper.CandyMgtCouponMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Slf4j
@Service
public class CandyMgtCouponAdminServiceImpl extends ServiceImpl<CandyMgtCouponMapper, CandyMgtCoupon> implements ICandyMgtCouponAdminService {
    @Autowired
    private CandyMgtCouponMapper candyMgtCouponMapper;
    @Autowired
    private CandyCouponMapper candyCouponMapper;
    @Autowired
    private ICandyCouponRuleAdminService candyCouponRuleAdminService;

    @Override
    @Transactional
    public boolean saveMgtCouponInfo(CandyCoupon initCoupon, CandyMgtCoupon initMgtCoupon, List<CandyCouponRule> initCouponRuleList) {
        int insertCt = candyCouponMapper.insert(initCoupon);
        insertCt += candyMgtCouponMapper.insert(initMgtCoupon);

        boolean saveBatch = candyCouponRuleAdminService.saveBatch(initCouponRuleList);

        if (insertCt < 2 || !saveBatch) {
            throw new LiquidnetServiceException();
        }
        return true;
    }

    @Override
    @Transactional
    public boolean updateMgtCouponInfo(CandyCoupon updateCoupon, CandyMgtCoupon updateMgtCoupon, List<CandyCouponRule> initCouponRuleList) {
        LambdaUpdateWrapper<CandyCoupon> couponLambdaUpdateWrapper = Wrappers.lambdaUpdate(CandyCoupon.class)
                .eq(CandyCoupon::getCouponId, updateCoupon.getCouponId())
                .eq(CandyCoupon::getState, 1)
                .eq(CandyCoupon::getExclusive, 10);
        int updateCt = candyCouponMapper.update(updateCoupon, couponLambdaUpdateWrapper);

        LambdaUpdateWrapper<CandyMgtCoupon> mgtCouponLambdaUpdateWrapper = Wrappers.lambdaUpdate(CandyMgtCoupon.class)
                .eq(CandyMgtCoupon::getMcouponId, updateMgtCoupon.getMcouponId())
                .eq(CandyMgtCoupon::getState, 1);
        updateCt += candyMgtCouponMapper.update(updateMgtCoupon, mgtCouponLambdaUpdateWrapper);


        LambdaUpdateWrapper<CandyCouponRule> couponRuleLambdaUpdateWrapper = Wrappers.lambdaUpdate(CandyCouponRule.class)
                .eq(CandyCouponRule::getCouponId, updateCoupon.getCouponId())
                .eq(CandyCouponRule::getState, 1)
                .set(CandyCouponRule::getState, 2);
        candyCouponRuleAdminService.update(couponRuleLambdaUpdateWrapper);

        if (updateCt < 2 || !candyCouponRuleAdminService.saveBatch(initCouponRuleList)) {
            throw new LiquidnetServiceException();
        }
        return true;
    }

    @Override
    public List<CandyMgtCouponInfoDto> listForMgtCouponInfoDto(CandyMgtCouponListParam listParam) {
        return candyMgtCouponMapper.selectMultiForMgtCouponInfoDto(listParam);
    }

    @Override
    public List<CandyMgtCouponMemberDto> listForMgtCouponMemberDto(List<String> mrightsIdList) {
        return candyMgtCouponMapper.selectMultiForMgtCouponMemberDto(mrightsIdList);
    }
}
