package com.liquidnet.service.adam.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 用户第三方账号信息
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class AdamThirdParty implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    private String uid;

    /**
     * 第三方ID
     */
    private String openId;

    /**
     * 第三方头像
     */
    private String avatar;

    /**
     * 第三方昵称
     */
    private String nickname;

    /**
     * 平台名称
     */
    private String platform;

    /**
     * 0-INIT,1-NORMAL,2-INVALID
     */
    private Integer state;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    private String comment;


}
