package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyUserRegisterRespDto
 * @Package com.liquidnet.service.galaxy.dto
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/10 20:46
 */
@ApiModel(value = "GalaxyUserRegisterRespDto", description = "素材上传")
@Data
public class GalaxyNftUploadRespDto implements Serializable,Cloneable {
    @ApiModelProperty(position = 1, required = true, value = "skuId")
    private String skuId;

    @ApiModelProperty(position = 1, required = true, value = "nft原始素材url")
    private String originalNftUrl;

    @ApiModelProperty(position = 1, required = true, value = "显示图原始素材url")
    private String originalDisplayUrl;

    @ApiModelProperty(position = 2, required = true, value = "nft链上访问地址")
    private String nftUrl;

    @ApiModelProperty(position = 3, required = true, value = "缩略图链上访问地址")
    private String displayUrl;


    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyNftUploadRespDto obj = new GalaxyNftUploadRespDto();

    public static GalaxyNftUploadRespDto getNew() {
        try {
            return (GalaxyNftUploadRespDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyNftUploadRespDto();
        }
    }
}
