package com.liquidnet.service.consumer.dragon.service.config;

import com.liquidnet.service.consumer.dragon.service.receiver.*;
import com.liquidnet.service.dragon.constant.DragonConstant;
import lombok.var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

import java.time.Duration;

@Configuration
public class RedisStreamConfig {

    @Autowired
    private RedisPayReceiver redisPayReceiver;
    @Autowired
    private RedisRefundReceiver redisRefundReceiver;
    @Autowired
    private RedisPayNotifyReceiver redisPayNotifyReceiver;
    @Autowired
    private RedisMchNotifyReceiver redisMchNotifyReceiver;
    @Autowired
    private RedisMchNotifyFailReceiver redisMchNotifyFailReceiver;

    @Bean
    public Subscription subscriptionPay0(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_GROUP.getCode(), "dragon-pay-0"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_KEY.getCode(), ReadOffset.lastConsumed()), redisPayReceiver);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPay1(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_GROUP.getCode(), "dragon-pay-1"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_KEY.getCode(), ReadOffset.lastConsumed()), redisPayReceiver);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionRefund0(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.DRAGON_REFUND_GROUP.getCode(), "dragon-refund-0"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.DRAGON_REFUND_KEY.getCode(), ReadOffset.lastConsumed()), redisRefundReceiver);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionRefund1(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.DRAGON_REFUND_GROUP.getCode(), "dragon-refund-1"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.DRAGON_REFUND_KEY.getCode(), ReadOffset.lastConsumed()), redisRefundReceiver);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPayNotify0(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_NOTIFY_GROUP.getCode(), "dragon-pay-notify-0"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_NOTIFY_KEY.getCode(), ReadOffset.lastConsumed()), redisPayNotifyReceiver);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPayNotify1(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_NOTIFY_GROUP.getCode(), "dragon-pay-notify-1"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_NOTIFY_KEY.getCode(), ReadOffset.lastConsumed()), redisPayNotifyReceiver);
        listenerContainer.start();
        return subscription;
    }
    @Bean
    public Subscription subscriptionMchNotify0(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.PAY_MCH_NOTIFY_GROUP.getCode(), "pay-mch-notify-0"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.PAY_MCH_NOTIFY_KEY.getCode(), ReadOffset.lastConsumed()), redisMchNotifyReceiver);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionMchNotify1(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.PAY_MCH_NOTIFY_GROUP.getCode(), "pay-mch-notify-1"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.PAY_MCH_NOTIFY_KEY.getCode(), ReadOffset.lastConsumed()), redisMchNotifyReceiver);
        listenerContainer.start();
        return subscription;
    }
    @Bean
    public Subscription subscriptionPayNotifyFail0(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.PAY_MCH_NOTIFY_ERROR_GROUP.getCode(), "pay-mch-notify-fail-0"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.PAY_MCH_NOTIFY_ERROR_KEY.getCode(), ReadOffset.lastConsumed()), redisMchNotifyFailReceiver);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPayNotifyFail1(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.PAY_MCH_NOTIFY_ERROR_GROUP.getCode(), "pay-mch-notify-fail-1"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.PAY_MCH_NOTIFY_ERROR_KEY.getCode(), ReadOffset.lastConsumed()), redisMchNotifyFailReceiver);
        listenerContainer.start();
        return subscription;
    }
}
