package com.liquidnet.service.sweet.controller;


import com.liquidnet.common.third.shumei.util.ShumeiUtil;

import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.dto.param.poster.SweetStrawberryParam;
import com.liquidnet.service.sweet.service.ISweetStrawberryPosterService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;



/**
 * <p>
 * 2021草莓音乐节海报活动表 前端控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-11-25
 */
@Api(tags = "活动-2021草莓音乐节海报")
@RestController
@RequestMapping("/strawberryPoster")
public class SweetStrawberryPosterController {

    @Autowired
    private ISweetStrawberryPosterService posterService;
    @Autowired
    private ShumeiUtil shumeiUtil;

    @PostMapping("addUserLikeMusician")
    @ApiOperation("用户添加喜爱音乐人")
    public ResponseDto<Boolean> addUserLikeMusician(@RequestBody SweetStrawberryParam sweetStrawberryParam){
        return posterService.addUserLikeMusician(sweetStrawberryParam);
    }



    @GetMapping("sensitiveText")
    @ApiOperation("敏感词判断")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "nickname", value = "nickname"),
            @ApiImplicitParam(type = "query", dataType = "String", name = "customText", value = "customText"),
    })
    public ResponseDto<Boolean> sensitiveText(
            @RequestParam(value = "nickname",required = false) String nickname,
            @RequestParam(value = "customText",required = false) String customText){
//        String currentUid = CurrentUtil.getCurrentUid(); 获取的是request->attributes->sub的值
        //此处判断不需要用户登录，所以使用时间代替
        String currentUid = DateUtil.now().getTime()+"";

        if (StringUtil.isNotEmpty(nickname)) {
            if (!shumeiUtil.checkText(currentUid, nickname)) {
                return ResponseDto.failure("0", nickname,false);
            }
        }
        if (StringUtil.isNotEmpty(customText)) {
            if (!shumeiUtil.checkText(currentUid, customText)) {
                return ResponseDto.failure("0", customText,false);
            }
        }
        return ResponseDto.failure("0",null,true);
    }

}
