package com.liquidnet.service.adam.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.type.TypeReference;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.commons.lang.util.SensitizeUtil;
import com.liquidnet.service.adam.dto.AdamUserInfoDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;

@ApiModel(value = "AdamUserInfoVo", description = "用户详情")
@Data
public class AdamUserInfoVo implements java.io.Serializable, Cloneable {
    private static final long serialVersionUID = 8479869354894030303L;
    @ApiModelProperty(position = 10, value = "用户ID[64]")
    private String uid;
    @ApiModelProperty(position = 11, value = "手机号[20]")
    private String mobile;
    @ApiModelProperty(position = 12, value = "登录密码[64]，只针对PHP老用户，新用户无此功能")
    private String passwd;
    //    @ApiModelProperty(position = 13, value = "支付密码[30]，暂无此功能")
//    private String payCode;
    @ApiModelProperty(position = 14, value = "昵称[32]")
    private String nickname;
    @ApiModelProperty(position = 15, value = "状态[1-正常,2-注销]")
    private Integer state;
    @ApiModelProperty(position = 16, value = "性别[32]")
    private AdamTagVo sex;
    @ApiModelProperty(position = 17, value = "生日[YYYY-MM-DD]")
    private String birthday;
    @ApiModelProperty(position = 18, value = "常住地/区域")
    private String area;
    @ApiModelProperty(position = 19, value = "个性签名")
    private String signature;
    @ApiModelProperty(position = 20, value = "头像")
    private String avatar;
    @ApiModelProperty(position = 21, value = "背景图")
    private String background;
    @ApiModelProperty(position = 22, value = "标签")
    private List<AdamTagParentVo> tagMe;
    @ApiModelProperty(position = 23, value = "注册时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime createAt;
    @ApiModelProperty(position = 24, value = "最近一次更新时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime updatedAt;
    @ApiModelProperty(position = 25, value = "注销时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime closedAt;
    @ApiModelProperty(position = 26, value = "完善信息进度[0-未完善,1-已完善]")
    private Integer isComplete;
    @ApiModelProperty(position = 27, value = "")
    private String rongCloudToken;
    @ApiModelProperty(position = 28, value = "身份二维码")
    private String qrCode;
    @ApiModelProperty(position = 30, value = "标记[0-普通用户｜2-过期会员｜10-老会员｜11-新会员]")
    private Integer stageMarker;

    private static final AdamUserInfoVo obj = new AdamUserInfoVo();

    public static AdamUserInfoVo getNew() {
        try {
            return (AdamUserInfoVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new AdamUserInfoVo();
    }

    public AdamUserInfoVo copy(AdamUserInfoDto source) {
        if (null == source) return this;
        this.setUid(source.getUid());
        this.setMobile(source.getMobile());
        this.setPasswd(source.getPasswd());
        this.setNickname(source.getNickname());
        this.setState(source.getState());

        this.setSex(JsonUtils.fromJson(source.getSex(), AdamTagVo.class));
        this.setBirthday(source.getBirthday());
        this.setArea(source.getArea());
        this.setSignature(source.getSignature());
        this.setAvatar(source.getAvatar());

        this.setBackground(source.getBackground());
        this.setTagMe(JsonUtils.fromJson(source.getTagMe(), new TypeReference<List<AdamTagParentVo>>() {
        }));
        this.setCreateAt(source.getCreateAt());
        this.setUpdatedAt(source.getUpdatedAt());
        this.setClosedAt(source.getClosedAt());

        this.setIsComplete(source.getIsComplete());
        this.setRongCloudToken(source.getRongCloudToken());
        this.setQrCode(source.getQrCode());
        return this;
    }

    public AdamUserInfoVo desensitize(Boolean reviewUserInfo) {
        this.setPasswd(null);
//        this.userInfo.setPayCode(null);
        this.setMobile(SensitizeUtil.custom(this.getMobile(), 3, 4));

        if (null != reviewUserInfo && reviewUserInfo) {
            if (!StringUtils.startsWith(this.nickname, "宇航员")) {
                this.setNickname(SensitizeUtil.custom(this.nickname, 1, 0) + "（审核中）");
            }
            if (StringUtils.isNotEmpty(this.signature)) {
                this.setSignature(SensitizeUtil.custom(this.signature, 1, 0) + "（审核中）");
            }
            if (StringUtils.isNotEmpty(this.avatar)) {
                List<String> defaultAvatarUrlList = Arrays.asList(
                        "https://img.zhengzai.tv/user/2021/07/27/a4cc2a4e6dcd44d1812dc60e079086b4.png",
                        "http://pic.zhengzai.tv/479639664.110103C8012C8595A200678A2C06D93D678A3D.png",
                        "http://pic.zhengzai.tv/default/avatar.png",
                        "http://img.zhengzai.tv/ticket/20171020/1508473543738.jpg"
                );
                if (!defaultAvatarUrlList.contains(this.avatar)) {
                    this.setAvatar("https://img.zhengzai.tv/headerreview.png");
                }
            }
            if (StringUtils.isNotEmpty(this.background)) {
                List<String> defaultBkgroudUrlList = Arrays.asList(
                        "https://img.zhengzai.tv/files/2021/01/13/5ffeab3584b7d.png",
                        "http://pic.zhengzai.tv/default/background.png",
                        "http://img.zhengzai.tv/album/20171027/1509106243302.png",
                        "https://img.zhengzai.tv/other/2021/07/27/150eeb0e20af4fc88e8a1ec57c46c362.png"
                );
                if (!defaultBkgroudUrlList.contains(this.background)) {
                    this.setBackground("https://img.zhengzai.tv/bkgroundreview.png");
                }
            }
        }

        return this;
    }

    public AdamUserInfoVo rating(AdamUserMemberVo userMemberVo) {
        if (null == userMemberVo) {
            this.setStageMarker(0);
        } else if (userMemberVo.isActive()) {
            this.setStageMarker(userMemberVo.isOldMember() ? 10 : 11);
        } else {
            this.setStageMarker(2);
        }
        return this;
    }
}
