package com.liquidnet.service.kylin.dto.vo.returns;

import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author TT
 */

@ApiModel(value = "NoticeKylinPerformanceVo", description = "票务")
@Data
public class NoticeKylinPerformanceVo  implements Serializable, Cloneable {
    private Integer mid;
    @ApiModelProperty(value = "主键")
    private String performancesId;
    @ApiModelProperty(value = "演出名称")
    private String title;
    @ApiModelProperty(value = "演出图片")
    private String imgPoster;
    @ApiModelProperty(value = "演出开始时间")
    private String timeStart;
    @ApiModelProperty(value = "演出结束时间")
    private String timeEnd;
    @ApiModelProperty(value = "停售时间")
    private String stopSellTime;
    @ApiModelProperty(value = "价格")
    private String price;
    @ApiModelProperty(value = "开售时间")
    private String sellTime;
    @ApiModelProperty(value = "城市id")
    private Integer cityId;
    @ApiModelProperty(value = "城市名称")
    private String cityName;
    @ApiModelProperty(value = "场地id")
    private String fieldId;
    @ApiModelProperty(value = "场地名称")
    private String fieldName;
    @ApiModelProperty(value = "搭售id")
    private String projectId;
    @ApiModelProperty(value = "巡演id")
    private String roadShowId;

    private static final NoticeKylinPerformanceVo obj = new NoticeKylinPerformanceVo();

    public static NoticeKylinPerformanceVo getNew() {
        try {
            return (NoticeKylinPerformanceVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new NoticeKylinPerformanceVo();
        }
    }

    public NoticeKylinPerformanceVo copy(KylinPerformanceVo kylinPerformanceVo){
        if (null == kylinPerformanceVo) return getNew();
        this.mid = kylinPerformanceVo.getMid();
        this.cityId = kylinPerformanceVo.getCityId();
        this.cityName = kylinPerformanceVo.getCityName();
        this.performancesId = kylinPerformanceVo.getPerformancesId();
        this.fieldId = kylinPerformanceVo.getFieldId();
        this.fieldName = kylinPerformanceVo.getFieldName();
        this.imgPoster = kylinPerformanceVo.getImgPoster();
        this.price = kylinPerformanceVo.getPrice();
        this.projectId = kylinPerformanceVo.getProjectId();
        this.roadShowId = kylinPerformanceVo.getRoadShowId();
        this.sellTime = kylinPerformanceVo.getSellTime();
        this.stopSellTime = kylinPerformanceVo.getStopSellTime();
        this.timeEnd = kylinPerformanceVo.getTimeEnd();
        this.timeStart = kylinPerformanceVo.getTimeStart();
        this.title = kylinPerformanceVo.getTitle();
        return this;
    }
}
