package com.liquidnet.service.kylin.dao;

import lombok.Data;

import java.math.BigDecimal;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: PerformanceOrderStatisticalDao
 * @Package com.liquidnet.service.kylin.dao
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/6/3 16:39
 */
@Data
public class PerformanceOrderStatisticalDao implements Cloneable{
    private String performancesId;
    private String ticketsId;
    private String title;// 票种名称
    private BigDecimal price;// 票种价格
    private Integer type;// 票种类型
    private String useStart;
    private String useEnd;
    private BigDecimal totalGeneral = BigDecimal.ZERO;// 库存数量
    private BigDecimal saleGeneral = BigDecimal.ZERO;// 销售数量
    private BigDecimal surplusGeneral = BigDecimal.ZERO;
    private BigDecimal totalSalePrice = BigDecimal.ZERO;
    private BigDecimal totalExchange = BigDecimal.ZERO;
    private BigDecimal totalRefundGeneral = BigDecimal.ZERO; // 退票总数量
    private BigDecimal totalRefundPrice = BigDecimal.ZERO;
    private BigDecimal totalMemberNumber = BigDecimal.ZERO;
    private BigDecimal totalPayingNumber = BigDecimal.ZERO;// 正在支付数量
    private BigDecimal totalBuyUsers = BigDecimal.ZERO;
    private BigDecimal totalVoucherCount = BigDecimal.ZERO;

    // 场次ID
    private String timeId;
    // 场次名称
    private String timeTitle;
    // vip购票数量
    private Integer vipBuyTotal = 0;
    // 全额退票总数
    private Integer fullRefundTicketTotal = 0;
    // 手续费退票总数
    private Integer handlingFeeRefundTicketTotal = 0;
    // 退票手续费总收益
    private BigDecimal refundFeeRevenueTotal = BigDecimal.ZERO;
    // 票面销售金额
    private BigDecimal audienceSalesAmountTotal = BigDecimal.ZERO;









    private static final PerformanceOrderStatisticalDao obj = new PerformanceOrderStatisticalDao();
    public static PerformanceOrderStatisticalDao getNew() {
        try {
            return (PerformanceOrderStatisticalDao) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new PerformanceOrderStatisticalDao();
        }
    }
}
