package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@ApiModel(value = "GoblinStoreNoticeVo", description = "店铺公告通知")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinStoreNoticeVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 156629407699728873L;
    @ApiModelProperty(position = 10, value = "店铺ID")
    private String storeId;
    @ApiModelProperty(position = 11, value = "公告ID")
    private String noticeId;
    @ApiModelProperty(position = 12, value = "公告内容")
    private String content;
    @ApiModelProperty(position = 13, value = "发布时间[yyyy-MM-dd HH:mm:ss]")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime releaseTime;
    @ApiModelProperty(position = 14, value = "长期有效[0-否|1-是]")
    private String longLasting;
    @ApiModelProperty(position = 15, value = "结束时间[yyyy-MM-dd HH:mm:ss]")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime cancellTime;
    @ApiModelProperty(position = 16, value = "公告状态[0-待发布|1-已发布]")
    private String status;
    @ApiModelProperty(position = 17, value = "删除标记[0-未删除|1-删除]")
    private String delFlg;

    private String createdBy;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;
    private String updatedBy;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime updatedAt;


    private static final GoblinStoreNoticeVo obj = new GoblinStoreNoticeVo();

    public static GoblinStoreNoticeVo getNew() {
        try {
            return (GoblinStoreNoticeVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinStoreNoticeVo();
        }
    }
}
