package com.liquidnet.client.admin;

import lombok.extern.slf4j.Slf4j;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableAsync;

import java.net.InetAddress;
import java.util.Arrays;

@Slf4j
@EnableAsync
@EnableEurekaClient
@SpringBootApplication(exclude = {DataSourceAutoConfiguration.class,RedisAutoConfiguration.class}, scanBasePackages = {"com.liquidnet"})
@MapperScan(basePackages = {"com.liquidnet.service.*.mapper"})
public class ClientAdminApplication implements CommandLineRunner {
    @Autowired
    private Environment environment;

    public static void main(String[] args) {
        // System.setProperty("spring.devtoolq.restart.enabled", "false");
        // System.setProperty("spring.devtoolq.restart.enabled", "false");
        SpringApplication.run(ClientAdminApplication.class, args);
    }

    @Override
    public void run(String... args) throws Exception {
        try {
            log.info("\n----------------------------------------------------------\n\t" +
                            "Application '{}' is running! Access URLs:\n\t" +
                            "Local: \t\thttp://127.0.0.1:{}\n\t" +
                            "External: \thttp://{}:{}{}/login\n\t" +
                            "Profile(s): \t{}\n----------------------------------------------------------",
                    environment.getProperty("spring.application.name"),
                    environment.getProperty("server.port"),
                    InetAddress.getLocalHost().getHostAddress(),
                    environment.getProperty("server.port"),
                    environment.getProperty("server.servlet.context-path"),
                    Arrays.toString(environment.getActiveProfiles()));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}