package com.liquidnet.service.bank.currencycloud.dto;

import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * currency cloud conversion param
 */
@Data
@ApiModel(description = "currency cloud conversion dto")
public class BankCcConversionDto {

    private String id;

    private String accountId;

    private String creatorContactId;

    private String shortReference;

    private Date settlementDate;

    private Date conversionDate;

    private String status;

    private String partnerStatus;

    private String currencyPair;

    private String buyCurrency;

    private String sellCurrency;

    private String fixedSide;

    private BigDecimal partnerBuyAmount;

    private BigDecimal partnerSellAmount;

    private BigDecimal clientBuyAmount;

    private BigDecimal clientSellAmount;

    private BigDecimal midMarketRate;

    private BigDecimal coreRate;

    private BigDecimal partnerRate;

    private BigDecimal clientRate;

    private Boolean depositRequired;

    private BigDecimal depositAmount;

    private String depositCurrency;

    private String depositStatus;

    private Date depositRequiredAt;

    private BigDecimal unallocatedFunds;

    private List<String> paymentIds;


    private String uniqueRequestId;

    private Date createdAt;

    private Date updatedAt;

    private String failureReason;

}
