package com.liquidnet.service.kylin.dto.param;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class PerformanceStep1Param implements Serializable {

    @ApiModelProperty(value = "演出id", example = "")
    @JsonIgnore
    private String performancesId;

    @ApiModelProperty(value = "封面图", example = "https://img.zhengzai.tv/partner/2019/05/14/5cda2d0520177.png")
    private String imgPoster;

    @ApiModelProperty(value = "演出名称", example = "测试演出")
    private String title;

    @ApiModelProperty(value = "演出类型 1音乐节 2演唱会 3小型演出 4展览 6舞台剧", example = "3")
    private String type;

    @ApiModelProperty(value = "演出开始时间", example = "2021-05-01 12:00:00")
    private String timeStart;

    @ApiModelProperty(value = "演出结束时间", example = "2021-05-04 12:00:00")
    private String timeEnd;

    @ApiModelProperty(value = "场地id", example = "1")
    private String fieldId;

    @ApiModelProperty(value = "演出公告", example = "这是演出公告")
    private String notice;

    @ApiModelProperty(value = "主办方id", example = "1")
    private String sponsorId;

    @ApiModelProperty(value = "主办方类型", example = "1")
    private String sponsorType;

    @ApiModelProperty(value = "主办方名称", example = "主办方名称")
    private String sponsor;

    @ApiModelProperty(value = "联系人", example = "联系人")
    private String contacts;

    @ApiModelProperty(value = "联系方式", example = "手机号")
    private String mobile;

    @ApiModelProperty(value = "演出详情", example = "<p>演出详情</p>")
    private String details;

    @ApiModelProperty(value = "演出批文地址", example = "这是一个演出批文地址")
    private String approvalUrl;

    @ApiModelProperty(value = "", example = "")
    @JsonIgnore
    private String createdAt;
}
