package com.liquidnet.service.kylin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 轮播图 模型
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-02
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinBanners implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * banners_id
     */
    private String bannersId;

    /**
     * 标题
     */
    private String name;

    /**
     * 封面图
     */
    private String coverImg;

    /**
     * 跳转id/url
     */
    private String targetId;

    /**
     * 跳转类型 6演出跳转 7商品跳转 8巡演跳转 12展示分享按钮的web连接 14积分商品详情 100活动跳转 999不跳转 998个人信息跳转
     */
    private Integer type;

    /**
     * 是否展示
     */
    private Integer isShow;

    /**
     * 展示位置
     */
    private Integer position;

    /**
     * 排序权重
     */
    private Integer sort;

    /**
     * comment
     */
    private String comment;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 修改时间
     */
    private LocalDateTime updatedAt;


}
