package com.liquidnet.service.kylin.controller.admin;


import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.kylin.dao.BannerDetailsDao;
import com.liquidnet.service.kylin.dto.param.BannersParam;
import com.liquidnet.service.kylin.service.impl.admin.KylinBannersServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 轮播图 后端管理控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-01
 */

@Api
@RestController
@RequestMapping("/admin/banners")
public class KylinBannersAdminController {

    @Autowired
    private KylinBannersServiceImpl kylinBannersServiceImpl;

    @PostMapping("")
    @ApiOperation(value = "创建banner")
    public ResponseDto<Object> create(@RequestBody BannersParam bannersParam) {
        Boolean res = kylinBannersServiceImpl.create(bannersParam);
        if (res) {
            return ResponseDto.success();
        } else {
            return ResponseDto.failure("添加banner失败");
        }
    }

    @PutMapping("")
    @ApiOperation(value = "修改banner")
    public ResponseDto<Object> update(@RequestBody BannersParam bannersParam) {
        Boolean res = kylinBannersServiceImpl.update(bannersParam);
        if (res) {
            return ResponseDto.success();
        } else {
            return ResponseDto.failure("修改banner失败");
        }
    }

    @GetMapping("{bannersId}")
    @ApiOperation(value = "banner详情")
    public ResponseDto<BannerDetailsDao> detail(@PathVariable("bannersId") String bannersId) {
        BannerDetailsDao result = null;
        result = kylinBannersServiceImpl.detail(bannersId);
        if (null != result) {
            return ResponseDto.success(result);
        } else {
            return ResponseDto.failure("获取banner详情失败");
        }
    }

}
