package com.liquidnet.service.kylin.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.common.mq.constant.MQConst;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.kylin.entity.KylinLackRegisters;
import com.liquidnet.service.kylin.mapper.KylinLackRegistersMapper;
import com.liquidnet.service.kylin.service.IKylinLackRegistersService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.Map;

@Service
public class KylinLackRegistersServiceImpl implements IKylinLackRegistersService {

    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Override
    public ResponseDto<String> addLackRegister(String performanceId, String ticketId) {
        try {
            KylinLackRegisters lackRegisters = KylinLackRegisters.getNew();
            Map token = CurrentUtil.getTokenClaims();
            lackRegisters.setLackRegistersId(IDGenerator.nextSnowId());
            lackRegisters.setPerformanceId(performanceId);
            lackRegisters.setTicketId(ticketId);
            lackRegisters.setUserId(CurrentUtil.getCurrentUid());
            lackRegisters.setUserName(StringUtils.defaultString(((String) token.get("nickname")), ""));
            lackRegisters.setUserMobile(StringUtils.defaultString(((String) token.get("mobile")), ""));
            lackRegisters.setIpAddress(CurrentUtil.getCliIpAddr());
            lackRegisters.setCreatedAt(LocalDateTime.now());
            rabbitTemplate.convertAndSend(MQConst.EXCHANGES_LIQUIDNET_SQL_PERFORMANCE_LACK, MQConst.ROUTING_KEY_SQL_PERFORMANCE_LACK,
                    SqlMapping.get("kylin_lack_register.insert", lackRegisters.getInsertObj()));
            return ResponseDto.success("登记成功");
        }catch (Exception e){
            e.printStackTrace();
            return ResponseDto.success("登记失败");
        }
    }
}
