package com.liquidnet.service.platform.service.impl.kylin;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.kylin.dto.param.PerformancePartnerVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketEntitiesVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketVo;
import com.liquidnet.service.kylin.dto.vo.partner.KylinTicketPartnerVo;
import com.liquidnet.service.kylin.dto.vo.partner.KylinTicketTimesPartnerVo;
import com.liquidnet.service.kylin.entity.*;
import com.liquidnet.service.kylin.mapper.*;
import com.liquidnet.service.kylin.service.*;
import com.liquidnet.service.platform.utils.DataUtils;
import com.liquidnet.service.platform.utils.PerformanceVoTask;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;

@Service
public class DataImpl {

    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private KylinPerformancesMapper performancesMapper;
    @Autowired
    private KylinPerformanceStatusMapper performanceStatusMapper;
    @Autowired
    private KylinPerformanceRelationsMapper performanceRelationsMapper;
    @Autowired
    private KylinTicketTimesMapper ticketTimesMapper;
    @Autowired
    private KylinTicketTimeRelationMapper ticketTimeRelationMapper;
    @Autowired
    private KylinTicketsMapper ticketsMapper;
    @Autowired
    private KylinTicketStatusMapper ticketStatusMapper;
    @Autowired
    private KylinTicketRelationsMapper ticketRelationsMapper;
    @Autowired
    private PerformanceVoTask performanceVoTask;

    @Autowired
    private DMCheckOrderTimeImpl dmCheckOrderTime;
    @Autowired
    private DMOrderTicketStatusImpl dmOrderTicketStatus;
    @Autowired
    private DMOrderTicketRelationsImpl dmOrderTicketRelations;
    @Autowired
    private DMOrderTicketEntitiesServiceImpl dmOrderTicketEntitiesService;

    @Autowired
    private DMRoadShowsServiceImpl dmRoadShowsService;

    @Autowired
    private DataUtils dataUtils;
    @Autowired
    private RedisUtil redisUtil;

    public boolean performance() {
        try {
            String driverClassName = "com.mysql.cj.jdbc.Driver";    //启动驱动
            String url = "jdbc:mysql://pc-2ze6z2hxkug559q79.mysql.polardb.rds.aliyuncs.com:3306/mall";    //设置连接路径
            String username = "readonly";    //数据库用户名
            String password = "ZWDsf8Fy";    //数据库连接密码
            Connection con = null;        //连接
            PreparedStatement pstmt = null;    //使用预编译语句
            ResultSet rs = null;    //获取的结果集
            //演出实体类
            KylinPerformances performances = new KylinPerformances();
            KylinPerformanceRelations performanceRelations = new KylinPerformanceRelations();
            KylinPerformanceStatus performanceStatus = new KylinPerformanceStatus();
            //场次实体类
            KylinTicketTimes ticketTimes = new KylinTicketTimes();
            KylinTicketTimeRelation ticketTimeRelation = new KylinTicketTimeRelation();
            //票实体类
            KylinTickets tickets = new KylinTickets();
            KylinTicketRelations ticketRelations = new KylinTicketRelations();
            KylinTicketStatus ticketStatus = new KylinTicketStatus();
            // 第三方Vo
            PerformancePartnerVo performancePartnerVo = new PerformancePartnerVo();
            KylinTicketTimesPartnerVo ticketTimesPartnerVo = new KylinTicketTimesPartnerVo();
            KylinTicketPartnerVo ticketPartnerVo = new KylinTicketPartnerVo();

            int count = 200;
            int page = 0;

            try {
                Class.forName(driverClassName); //执行驱动
                con = DriverManager.getConnection(url, username, password); //获取连接
                String sqlAllCount = "select count(0) as 'allCount' from performances where status >= 3 and created_at > '2021-01-01 00:00:01'"; //设置的预编译语句格式
                pstmt = con.prepareStatement(sqlAllCount);
                ResultSet allCount = pstmt.executeQuery();
                ArrayList<String> performanceIds = new ArrayList<>();
                int allCountResult = 0;//共多少条
                int rowCount = 0;//当前多少条
                boolean isBreak = false;//是否终端循环
                while (allCount.next()) {
                    allCountResult = allCount.getInt("allCount");
                }

                do {
                    String sql = "select * from performances where status >= 3 and created_at > '2021-01-01 00:00:01' limit " + count * page + " ," + count; //设置的预编译语句格式
                    pstmt = con.prepareStatement(sql);
                    ResultSet resultData = pstmt.executeQuery();
                    int performanceId = 0;
                    //演出数据
                    while (resultData.next()) {
                        performanceId = resultData.getInt("id");
//                    performances.setPerformancesId(IDGenerator.nextSnowId().toString());
                        performances.setPerformancesId(resultData.getInt("id") + "");
                        performanceIds.add(performances.getPerformancesId());
                        performances.setTitle(resultData.getString("title"));
                        performances.setType(resultData.getInt("type") == 1 ? 101 : 102);
                        if (resultData.getInt("road_show_id") > 0) {
                            performances.setType(103);
                        }
                        performances.setImgPoster(resultData.getString("img_poster"));
                        performances.setApprovalUrl(resultData.getString("approval_url"));
                        performances.setNotice(resultData.getString("notice"));
                        performances.setSponsorId(resultData.getString("sponsor_id"));
                        performances.setSponsorType(resultData.getString("sponsor_type"));
                        performances.setSponsor(resultData.getString("sponsor"));
                        performances.setContacts(resultData.getString("contacts"));
                        performances.setMobile(resultData.getString("mobile"));
                        performances.setDescribes(resultData.getString("describe"));
                        performances.setDetails(resultData.getString("detail"));
                        performances.setCityId(Integer.parseInt(resultData.getString("city_id")));
                        performances.setCityName((String) redisUtil.hget(KylinRedisConst.FIELDS + ":" + resultData.getInt("field_id"), "city_name"));
                        performances.setNoticeImage("[{\"id\":1,\"sort\":1,\"message\":\"因演出票品非普通商品，其背后承载的文化服务具有时效性、稀缺性等特征，故不适用7天无理由退货政策。因“不可抗力”导致的演出取消或延期除外。\",\"title\":\"门票退换\",\"type\":\"image\",\"imgUrl\":\"http://img-zhengzai-tv.oss-cn-hangzhou.aliyuncs.com/partner/2019/01/21/5c45722882a13.png\"},{\"id\":7,\"sort\":2,\"message\":\"凭订单二维码或手机号兑票入场，二维码或手机号请勿泄露，以免影响入场。个人原因导致的信息泄露，主办方/平台方不承担任何责任。\",\"title\":\"电子票\",\"type\":\"image\",\"imgUrl\":\"http://img-zhengzai-tv.oss-cn-hangzhou.aliyuncs.com/partner/2019/01/21/5c456d9482fb9.png\"},{\"id\":3,\"sort\":3,\"message\":\"本场演出不设座位，均为站席观演。\",\"title\":\"仅设站席\",\"type\":\"image\",\"imgUrl\":\"http://img-zhengzai-tv.oss-cn-hangzhou.aliyuncs.com/partner/2019/01/21/5c456e93db0b9.png\"},{\"id\":12,\"sort\":4,\"message\":\"每场现场票数量由场地方决定，具体请到现场询问。\",\"title\":\"现场票\",\"type\":\"image\",\"imgUrl\":\"http://img-zhengzai-tv.oss-cn-hangzhou.aliyuncs.com/partner/2019/06/17/5d07647eaa55f.png\"}]");
                        performances.setTimeStart(DateUtil.Formatter.yyyyMMddHHmmssS.parse(resultData.getTimestamp("time_start").toString()));
                        performances.setTimeEnd(DateUtil.Formatter.yyyyMMddHHmmssS.parse(resultData.getTimestamp("time_end").toString()));
                        if (null != resultData.getString("audit_submit_time")) {
                            performances.setAuditTime(DateUtil.Formatter.yyyyMMddHHmmss.parse(resultData.getString("audit_submit_time")));
                        }
                        performances.setRejectTxt(resultData.getString("reject_text"));
                        performances.setSort(resultData.getInt("sort"));
                        performances.setComment("");
                        performances.setCreatedAt(DateUtil.Formatter.yyyyMMddHHmmssS.parse(resultData.getTimestamp("created_at").toString()));
                        if (null != resultData.getTimestamp("updated_at")) {
                            performances.setUpdatedAt(DateUtil.Formatter.yyyyMMddHHmmssS.parse(resultData.getTimestamp("updated_at").toString()));
                        }
                        //Status
                        performanceStatus.setPerformanceStatusId(IDGenerator.nextSnowId().toString());
                        performanceStatus.setPerformanceId(performances.getPerformancesId());
                        performanceStatus.setIsShow(resultData.getInt("show"));
                        performanceStatus.setStatus(resultData.getInt("status"));
                        performanceStatus.setStatusSell(1);
                        performanceStatus.setIsDistribution(0);
                        performanceStatus.setSyncAgent(0);
                        performanceStatus.setSyncDamai(0);
                        performanceStatus.setAuditStatus(1);
                        performanceStatus.setIsTrueName(resultData.getString("need_id_card").equals("yes") ? 1 : 0);
                        performanceStatus.setLimitCount(resultData.getInt("num_limit_mobile"));
                        performanceStatus.setLimitCountMember(1);
                        performanceStatus.setIsRecommend(resultData.getInt("is_recommend"));
                        performanceStatus.setCreatedAt(performances.getCreatedAt());
                        performanceStatus.setUpdatedAt(performances.getUpdatedAt());
                        //Relation
                        performanceRelations.setPerformanceRelationsId(IDGenerator.nextSnowId().toString());
                        performanceRelations.setPerformanceId(performances.getPerformancesId());
                        performanceRelations.setCopyId(resultData.getInt("copy_id") + "");
                        performanceRelations.setMerchantId(resultData.getInt("merchant_id") + "");
                        performanceRelations.setFieldId(resultData.getInt("field_id") + "");
                        performanceRelations.setRoadShowId(resultData.getInt("road_show_id") + "");
                        performanceRelations.setProjectId("");
                        performanceRelations.setVideoId("");
                        performanceRelations.setCreatedAt(performances.getCreatedAt());
                        performanceRelations.setUpdatedAt(performances.getUpdatedAt());

                        performancesMapper.insert(performances);
                        performanceStatusMapper.insert(performanceStatus);
                        performanceRelationsMapper.insert(performanceRelations);

                        performancePartnerVo.setPerformancesId(performances.getPerformancesId());
                        performancePartnerVo.setImgPoster(performances.getImgPoster());
                        performancePartnerVo.setTitle(performances.getTitle());
                        performancePartnerVo.setType(performances.getType());
                        performancePartnerVo.setTimeStart(DateUtil.Formatter.yyyyMMddHHmmss.format(performances.getTimeStart()));
                        performancePartnerVo.setTimeEnd(DateUtil.Formatter.yyyyMMddHHmmss.format(performances.getTimeEnd()));
                        performancePartnerVo.setFieldId(performanceRelations.getFieldId());
                        performancePartnerVo.setFieldName((String) redisUtil.hget(KylinRedisConst.FIELDS + ":" + performanceRelations.getFieldId(), "name"));
                        performancePartnerVo.setNotice(performances.getNotice());
                        performancePartnerVo.setSponsorId(performances.getSponsorId());
                        performancePartnerVo.setSponsorType(performances.getSponsorType());
                        performancePartnerVo.setSponsor(performances.getSponsor());
                        performancePartnerVo.setContacts(performances.getContacts());
                        performancePartnerVo.setMobile(performances.getMobile());
                        performancePartnerVo.setDetails(performances.getDetails());
                        performancePartnerVo.setApprovalUrl(performances.getApprovalUrl());
                        performancePartnerVo.setPayCountdownMinute(5);
                        performancePartnerVo.setNoticeIds(new ArrayList<String>() {{
                            add("1");
                            add("3");
                            add("7");
                            add("12");
                        }});
                        performancePartnerVo.setNoticeImage(performances.getNoticeImage());
                        performancePartnerVo.setIsTrueName(performanceStatus.getIsTrueName());
                        performancePartnerVo.setLimitCount(performanceStatus.getLimitCount());
                        performancePartnerVo.setIsSubmit(1);
                        performancePartnerVo.setStatus(performanceStatus.getStatus());
                        performancePartnerVo.setMerchantId(performanceRelations.getMerchantId());
                        performancePartnerVo.setDescribes(performances.getDescribes());
                        performancePartnerVo.setStatusSell(performanceStatus.getStatusSell());
                        performancePartnerVo.setRoadShowId(performanceRelations.getRoadShowId());
                        performancePartnerVo.setRejectTxt(performances.getRejectTxt());
                        performancePartnerVo.setAuditStatus(1);
                        performancePartnerVo.setIsShow(performanceStatus.getIsShow());
                        performancePartnerVo.setProjectId(performances.getProvinceId());
//                        performancePartnerVo.setNoticeIds();
                        performancePartnerVo.setCreatedAt(DateUtil.Formatter.yyyyMMddHHmmss.format(performances.getCreatedAt()));
                        performancePartnerVo.setUpdatedAt(DateUtil.Formatter.yyyyMMddHHmmss.format(performances.getUpdatedAt()));
                        performancePartnerVo.setIsCreateSave(0);
                        mongoTemplate.insert(performancePartnerVo, PerformancePartnerVo.class.getSimpleName());

                        //场次相关
                        String timesSql = "select type,use_start,use_end,created_at from tickets where performance_id = " + performanceId + " GROUP BY use_start,use_end"; //设置的预编译语句格式
                        pstmt = con.prepareStatement(timesSql);
                        ResultSet timesData = pstmt.executeQuery();
                        HashMap<String, String> timeMap = new HashMap<>();
                        while (timesData.next()) {
                            String title = "";
                            String useStart = DateUtil.Formatter.yyyyMMddHHmmssS.parse(timesData.getTimestamp("use_start").toString()).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"));
                            ;
                            String useEnd = DateUtil.Formatter.yyyyMMddHHmmssS.parse(timesData.getTimestamp("use_end").toString()).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"));
                            ;
                            if (timesData.getInt("type") == 1) {
                                title = useStart;
                            } else {
                                title = useStart + "-" + useEnd;
                            }
                            //times
                            ticketTimes.setTicketTimesId(IDGenerator.nextSnowId().toString());
                            ticketTimes.setTitle(title);
                            ticketTimes.setType(timesData.getInt("type"));
                            ticketTimes.setStatus(1);
                            ticketTimes.setUseStart(DateUtil.Formatter.yyyyMMddHHmmssS.parse(timesData.getTimestamp("use_start").toString()));
                            ticketTimes.setUseEnd(DateUtil.Formatter.yyyyMMddHHmmssS.parse(timesData.getTimestamp("use_end").toString()));
                            ticketTimes.setComment("");
                            if (null != timesData.getTimestamp("created_at")) {
                                ticketTimes.setCreatedAt(DateUtil.Formatter.yyyyMMddHHmmssS.parse(timesData.getTimestamp("created_at").toString()));
                            }
                            ticketTimes.setUpdatedAt(null);
                            //Relation
                            ticketTimeRelation.setTicketTimeRelationId(IDGenerator.nextSnowId().toString());
                            ticketTimeRelation.setTimesId(ticketTimes.getTicketTimesId());
                            ticketTimeRelation.setPerformanceId(performanceId + "");
                            ticketTimeRelation.setCreatedAt(ticketTimes.getCreatedAt());
                            timeMap.put(title, ticketTimes.getTicketTimesId());

                            ticketTimesMapper.insert(ticketTimes);
                            ticketTimeRelationMapper.insert(ticketTimeRelation);
                            ticketTimesPartnerVo.setTicketTimesId(ticketTimes.getTicketTimesId());
                            ticketTimesPartnerVo.setPerformancesId(ticketTimeRelation.getPerformanceId());
                            ticketTimesPartnerVo.setType(ticketTimes.getType());
                            ticketTimesPartnerVo.setTitle(ticketTimes.getTitle());
                            ticketTimesPartnerVo.setStatus(ticketTimes.getStatus());
                            ticketTimesPartnerVo.setUseEnd(DateUtil.Formatter.yyyyMMddHHmmss.format(ticketTimes.getUseEnd()));
                            ticketTimesPartnerVo.setUseStart(DateUtil.Formatter.yyyyMMddHHmmss.format(ticketTimes.getUseStart()));
                            ticketTimesPartnerVo.setCreatedAt(DateUtil.Formatter.yyyyMMddHHmmss.format(ticketTimes.getCreatedAt()));
                            mongoTemplate.insert(ticketTimesPartnerVo, KylinTicketTimesPartnerVo.class.getSimpleName());
                        }

                        //票sql
                        String ticketSql = "select * from tickets where performance_id = " + performanceId; //设置的预编译语句格式
                        pstmt = con.prepareStatement(ticketSql);
                        ResultSet ticketData = pstmt.executeQuery();
                        while (ticketData.next()) {
                            //会员sql
                            String memberSql = "select status from performance_members where performance_id = " + performanceId; //设置的预编译语句格式
                            pstmt = con.prepareStatement(memberSql);
                            int isMember = 0;
                            ResultSet memberData = pstmt.executeQuery();
                            while (memberData.next()) {
                                isMember = memberData.getInt("status") == 1 ? 1 : 0;
                            }


                            String title = "";
                            String useStart = DateUtil.Formatter.yyyyMMddHHmmssS.parse(ticketData.getTimestamp("use_start").toString()).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"));

                            String useEnd = DateUtil.Formatter.yyyyMMddHHmmssS.parse(ticketData.getTimestamp("use_end").toString()).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"));

                            if (ticketData.getInt("type") == 1) {
                                title = useStart;
                            } else {
                                title = useStart + "-" + useEnd;
                            }
                            //Ticket
//                    tickets.setPerformancesId(IDGenerator.nextSnowId().toString());
                            tickets.setTicketsId(ticketData.getInt("id") + "");
                            tickets.setTitle(ticketData.getString("title"));
                            tickets.setType(ticketData.getInt("type"));
                            tickets.setPrice(ticketData.getBigDecimal("price"));
                            tickets.setPriceExpress(ticketData.getBigDecimal("price_express"));
                            tickets.setPriceDiscountMember(new BigDecimal("0.00"));
                            tickets.setPriceDiscount(new BigDecimal("0.00"));
                            tickets.setDescribes(ticketData.getString("describe"));
                            tickets.setDescribeExpress(ticketData.getString("describe_express"));
                            tickets.setDescribeElectronic(ticketData.getString("describe_electronic"));
                            tickets.setAdvanceMinuteMember(5);
                            tickets.setTimeStart(DateUtil.Formatter.yyyyMMddHHmmssS.parse(ticketData.getTimestamp("time_start").toString()));
                            tickets.setTimeEnd(DateUtil.Formatter.yyyyMMddHHmmssS.parse(ticketData.getTimestamp("time_end").toString()));
                            if (null != ticketData.getTimestamp("time_end_express")) {
                                tickets.setTimeEndExpress(DateUtil.Formatter.yyyyMMddHHmmssS.parse(ticketData.getTimestamp("time_end_express").toString()));
                            }
                            tickets.setUseStart(DateUtil.Formatter.yyyyMMddHHmmssS.parse(ticketData.getTimestamp("use_start").toString()));
                            tickets.setUseEnd(DateUtil.Formatter.yyyyMMddHHmmssS.parse(ticketData.getTimestamp("use_end").toString()));
                            tickets.setPayCountdownMinute(5);
                            tickets.setSaleRemindMinute(60);
                            tickets.setComment("");
                            if (null != ticketData.getTimestamp("created_at")) {
                                tickets.setCreatedAt(DateUtil.Formatter.yyyyMMddHHmmssS.parse(ticketData.getTimestamp("created_at").toString()));
                            }
                            if (null != ticketData.getTimestamp("updated_at")) {
                                tickets.setUpdatedAt(DateUtil.Formatter.yyyyMMddHHmmssS.parse(ticketData.getTimestamp("updated_at").toString()));
                            }
                            //Status
                            ticketStatus.setTicketStatusId(IDGenerator.nextSnowId().toString());
                            ticketStatus.setTicketId(tickets.getTicketsId());
                            ticketStatus.setIsStudent(ticketData.getString("student").equals("yes") ? 1 : 0);
                            ticketStatus.setIsElectronic(ticketData.getInt("is_electronic"));
                            ticketStatus.setIsExpress(ticketData.getInt("is_express"));
                            ticketStatus.setStatus(ticketData.getInt("status"));
                            ticketStatus.setCounts(1);
                            ticketStatus.setStatusExchange(7);
                            ticketStatus.setIsShowCode(0);
//                    ticketStatus.setQrCodeShowTime();
                            ticketStatus.setIsLackRegister(ticketData.getInt("is_lack_register"));
                            ticketStatus.setTotalGeneral(ticketData.getInt("total_general"));
                            ticketStatus.setTotalExchange(ticketData.getInt("total_exchange"));
                            ticketStatus.setSurplusGeneral(ticketData.getInt("surplus_general"));
                            ticketStatus.setSurplusExchange(ticketData.getInt("surplus_exchange"));
                            ticketStatus.setExpressType(ticketData.getInt("express_type"));
                            ticketStatus.setIsTrueName(ticketData.getString("need_id_card").equals("yes") ? 1 : 0);
                            ticketStatus.setLimitCount(ticketData.getInt("num_limit_mobile"));
                            ticketStatus.setMemberLimitCount(1);
                            ticketStatus.setIsTransfer(0);
                            ticketStatus.setIsExclusive(ticketData.getInt("is_exclusive"));
                            ticketStatus.setIsMember(isMember);
                            ticketStatus.setIsAgent(0);
                            ticketStatus.setSyncDamai(0);
                            ticketStatus.setCreatedAt(tickets.getCreatedAt());
                            if (null != ticketData.getTimestamp("updated_at")) {
                                ticketStatus.setUpdatedAt(tickets.getUpdatedAt());
                            }
                            //Relation
                            ticketRelations.setTicketRelationsId(IDGenerator.nextSnowId().toString());
                            ticketRelations.setTicketId(tickets.getTicketsId());
                            ticketRelations.setTimesId(timeMap.get(title));
                            ticketRelations.setCreatedAt(tickets.getCreatedAt());
                            if (null != ticketData.getTimestamp("updated_at")) {
                                ticketRelations.setUpdatedAt(tickets.getUpdatedAt());
                            }

                            ticketsMapper.insert(tickets);
                            ticketStatusMapper.insert(ticketStatus);
                            ticketRelationsMapper.insert(ticketRelations);

                            dataUtils.setSurplusGeneral(tickets.getTicketsId(), ticketStatus.getSurplusGeneral());
                            dataUtils.setSurplusExchange(tickets.getTicketsId(), ticketStatus.getSurplusExchange());
                            //Vo
                            ticketPartnerVo.setTicketsId(tickets.getTicketsId());
                            ticketPartnerVo.setTitle(tickets.getTitle());
                            ticketPartnerVo.setIsStudent(ticketStatus.getIsStudent());
                            ticketPartnerVo.setIsElectronic(ticketStatus.getIsElectronic());
                            ticketPartnerVo.setIsExpress(ticketStatus.getIsExpress());
                            ticketPartnerVo.setType(tickets.getType());
                            ticketPartnerVo.setPrice(tickets.getPrice());
                            ticketPartnerVo.setTimeEndExpress(DateUtil.Formatter.yyyyMMddHHmmss.format(tickets.getTimeEndExpress()));
                            ticketPartnerVo.setTotalGeneral(ticketStatus.getTotalGeneral());
                            ticketPartnerVo.setTotalExchange(ticketStatus.getTotalExchange());
                            ticketPartnerVo.setLimitCount(ticketStatus.getLimitCount());
                            ticketPartnerVo.setCounts(1);
                            ticketPartnerVo.setTimeStart(DateUtil.Formatter.yyyyMMddHHmmss.format(tickets.getTimeStart()));
                            ticketPartnerVo.setTimeEnd(DateUtil.Formatter.yyyyMMddHHmmss.format(tickets.getTimeEnd()));
                            ticketPartnerVo.setUseStart(DateUtil.Formatter.yyyyMMddHHmmss.format(tickets.getUseStart()));
                            ticketPartnerVo.setUseEnd(DateUtil.Formatter.yyyyMMddHHmmss.format(tickets.getUseEnd()));
                            ticketPartnerVo.setDescribes(tickets.getDescribes());
                            ticketPartnerVo.setDescribeExpress(tickets.getDescribeExpress());
                            ticketPartnerVo.setDescribeElectronic(tickets.getDescribeElectronic());
                            ticketPartnerVo.setStatus(ticketStatus.getStatus());
                            ticketPartnerVo.setIsShowCode(ticketStatus.getIsShowCode());
//                        ticketPartnerVo.setQrCodeShowTime();
                            ticketPartnerVo.setTimesId(ticketRelations.getTimesId());
                            ticketPartnerVo.setIsLackRegister(ticketStatus.getIsLackRegister());
                            ticketPartnerVo.setSurplusGeneral(ticketStatus.getSurplusGeneral());
                            ticketPartnerVo.setSurplusExchange(ticketStatus.getSurplusExchange());
                            ticketPartnerVo.setExpressType(ticketStatus.getExpressType());
                            ticketPartnerVo.setIsTransfer(ticketStatus.getIsTransfer());
                            ticketPartnerVo.setIsMember(ticketStatus.getIsMember());
                            ticketPartnerVo.setIsExclusive(ticketStatus.getIsExclusive());
                            ticketPartnerVo.setCreatedAt(DateUtil.Formatter.yyyyMMddHHmmss.format(tickets.getCreatedAt()));
                            ticketPartnerVo.setUpdatedAt(DateUtil.Formatter.yyyyMMddHHmmss.format(tickets.getUpdatedAt()));
                            mongoTemplate.insert(ticketPartnerVo, KylinTicketPartnerVo.class.getSimpleName());

                        }
                    }

                    for (int i = 0; i < performanceIds.size(); i++) {
                        performanceVoTask.performanceVoStatus(performanceIds.get(i));
                    }

                    resultData.last();
                    rowCount += resultData.getRow();
                    if (allCountResult > rowCount) {
                        isBreak = true;
                        page += 1;
                    } else {
                        isBreak = false;
                    }
                } while (isBreak);
                return true;
            } catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            } finally {
                //关闭资源,倒关
                try {
                    if (rs != null) rs.close();
                    if (pstmt != null) pstmt.close();
                    if (con != null) con.close();  //必须要关
                } catch (Exception e) {
                }
            }
        } catch (Exception e) {
            return false;
        }
    }

    public boolean order(String month) {

        String driverClassName = "com.mysql.cj.jdbc.Driver";    //启动驱动
        String url = "jdbc:mysql://pc-2ze6z2hxkug559q79.mysql.polardb.rds.aliyuncs.com:3306/mall";    //设置连接路径
//        String url = "jdbc:mysql://zhengzai.mysql.polardb.rds.aliyuncs.com:3306/mall";
        String username = "readonly";    //数据库用户名
        String password = "ZWDsf8Fy";    //数据库连接密码
        Connection con = null;        //连接
        PreparedStatement pstmt = null;    //使用预编译语句
        ResultSet rs = null;    //获取的结果集

        try {

            int count = 3000;
            int page = 0;

            Class.forName(driverClassName); //执行驱动
            con = DriverManager.getConnection(url, username, password); //获取连接
            String sqlAllCount = "select count(0) as 'allCount' from order_tickets where performance_id  > 5721 and status != 2 and status != -1 and created_at like '2021-" + month + "%'"; //设置的预编译语句格式
//            String sqlAllCount = "select count(0) as 'allCount' from order_tickets where performance_id = "+month + " and status != 2 and status !=-1"; //设置的预编译语句格式
            System.out.println(" SQL COUNT = " + sqlAllCount);
            pstmt = con.prepareStatement(sqlAllCount);
            ResultSet allCount = pstmt.executeQuery();
            int allCountResult = 0;//共多少条
            int rowCount = 0;//当前多少条
            boolean isBreak = false;//是否终端循环
            while (allCount.next()) {
                allCountResult = allCount.getInt("allCount");
            }

            do {
                ArrayList<KylinOrderTickets> orderList = new ArrayList();
                ArrayList<KylinOrderTicketStatus> orderStatusList = new ArrayList();
                ArrayList<KylinOrderTicketRelations> orderRelationList = new ArrayList();
                ArrayList<KylinOrderTicketEntities> orderEntitiesList = new ArrayList();

                ArrayList<KylinOrderTicketVo> orderListVo = new ArrayList();
                ArrayList<KylinOrderTicketEntitiesVo> orderEntitiesListVo = new ArrayList();
                //订单
                String sql = "select * from order_tickets where performance_id  > 5721 and status != 2 and  status != -1 and created_at like '2021-" + month + "%' limit " + count * page + " ," + count; //设置的预编译语句格式
//                String sql = "select *  from order_tickets where performance_id = "+month +" and status != 2 limit " + count * page + " ," + count;
                System.out.println(" SQL DATA = " + sql);
                pstmt = con.prepareStatement(sql);
                ResultSet orderData = pstmt.executeQuery();
                while (orderData.next()) {

                    KylinOrderTickets orderTickets = new KylinOrderTickets();
                    KylinOrderTicketStatus orderTicketStatus = new KylinOrderTicketStatus();
                    KylinOrderTicketRelations orderTicketRelations = new KylinOrderTicketRelations();
                    KylinOrderTicketEntities orderTicketEntities = new KylinOrderTicketEntities();
                    KylinOrderTicketVo orderTicketVo = new KylinOrderTicketVo();

                    ArrayList<KylinOrderTicketEntitiesVo> entitiesVosList = new ArrayList<>();
                    String ticketSql = "select student,use_end,use_start,title,type from tickets where id = " + orderData.getInt("ticket_id"); //设置的预编译语句格式
                    pstmt = con.prepareStatement(ticketSql);
                    ResultSet ticketData = pstmt.executeQuery();
                    int isStudent = 0;
                    String useEnd = "";
                    String useStart = "";
                    String ticketTitle = "";
                    int ticketType = 0;
                    while (ticketData.next()) {
                        isStudent = ticketData.getString("student").equals("yes") ? 1 : 0;
                        ticketTitle = ticketData.getString("title");
                        ticketType = ticketData.getInt("type");
                        useEnd = DateUtil.Formatter.yyyyMMddHHmmss.format(DateUtil.Formatter.yyyyMMddHHmmssS.parse(ticketData.getTimestamp("use_end").toString()));
                        useStart = DateUtil.Formatter.yyyyMMddHHmmss.format(DateUtil.Formatter.yyyyMMddHHmmssS.parse(ticketData.getTimestamp("use_start").toString()));
                    }

                    //退款
                    String refundSql = "select refund_table_id,sum(refund_number) as 'refund_number',sum(refund_price) as 'refund_price' from order_refunds where refund_table = 'order_ticket_entities' and order_id = " + orderData.getInt("id") + " group by refund_table_id"; //设置的预编译语句格式
                    pstmt = con.prepareStatement(refundSql);
                    int refundNumber = 0;
                    BigDecimal refundPrice = new BigDecimal("0.00");
                    ResultSet refundData = pstmt.executeQuery();
                    while (refundData.next()) {
                        refundNumber += refundData.getInt("refund_number");
                        refundPrice = refundPrice.add(refundData.getBigDecimal("refund_price"));
                    }

                    //演出
                    String performancedSql = "select time_start,img_poster,need_id_card,notice from performances where id =" + orderData.getInt("performance_id");
                    pstmt = con.prepareStatement(performancedSql);
                    ResultSet performanceData = pstmt.executeQuery();
                    String performanceTimeStart = "";
                    String performanceImg = "";
                    int isTrueName = 0;
                    String notice = "";
                    while (performanceData.next()) {
                        performanceTimeStart = DateUtil.Formatter.yyyyMMddHHmmss.format(DateUtil.Formatter.yyyyMMddHHmmssS.parse(performanceData.getTimestamp("time_start").toString()));
                        performanceImg = performanceData.getString("img_poster");
                        isTrueName = performanceData.getString("need_id_card").equals("yes") ? 1 : 0;
                        notice = performanceData.getString("notice");
                    }

                    orderTickets.setOrderTicketsId(orderData.getInt("id") + "");
                    orderTickets.setUserId(orderData.getInt("user_id") + "");
                    orderTickets.setUserName(orderData.getString("user_name"));
                    orderTickets.setUserMobile(orderData.getString("user_mobile"));
                    orderTickets.setPerformanceTitle(orderData.getString("performance_title"));
                    orderTickets.setOrderCode(orderData.getString("order_code"));
                    orderTickets.setPayCode(orderData.getString("pay_code"));
                    orderTickets.setQrCode(orderData.getString("qr_code"));
                    orderTickets.setOrderType(orderData.getString("order_type"));
                    orderTickets.setOrderSource(orderData.getString("order_type"));
                    orderTickets.setOrderVersion(orderData.getString("order_version"));
                    orderTickets.setNumber(orderData.getInt("number"));
                    orderTickets.setPrice(orderData.getBigDecimal("price"));
                    orderTickets.setPriceMember(orderData.getBigDecimal("price_member"));
                    orderTickets.setPriceTotal(orderData.getBigDecimal("price_total"));
                    orderTickets.setPriceVoucher(orderData.getBigDecimal("price_voucher"));
                    orderTickets.setPriceActual(orderData.getBigDecimal("price_actual"));
                    orderTickets.setPriceExpress(orderData.getBigDecimal("price_express"));

                    orderTickets.setPriceRefund(refundPrice);
                    orderTickets.setRefundNumber(refundNumber);

                    orderTickets.setPayType(orderData.getString("pay_type"));
                    orderTickets.setPaymentType(orderData.getString("payment_type"));
                    orderTickets.setTimePay(orderData.getString("time_pay"));
                    orderTickets.setExpressContacts(orderData.getString("express_contacts"));
                    orderTickets.setExpressAddress(orderData.getString("express_address"));
                    orderTickets.setExpressPhone(orderData.getString("express_phone"));
                    orderTickets.setCouponType(orderData.getString("coupon_type"));
                    orderTickets.setGetTicketType(orderData.getString("get_ticket_type"));
                    orderTickets.setGetTicketDescribe(orderData.getString("get_ticket_describe"));
                    orderTickets.setPayCountdownMinute(orderData.getInt("pay_countdown_minute"));
                    orderTickets.setComment("");
                    orderTickets.setCreatedAt(DateUtil.Formatter.yyyyMMddHHmmssS.parse(orderData.getTimestamp("created_at").toString()));
                    if (null != orderData.getTimestamp("updated_at")) {
                        orderTickets.setUpdatedAt(DateUtil.Formatter.yyyyMMddHHmmssS.parse(orderData.getTimestamp("updated_at").toString()));
                    }

                    orderTicketStatus.setOrderTicketStatusId(IDGenerator.nextSnowId().toString());
                    orderTicketStatus.setOrderId(orderTickets.getOrderTicketsId());
                    orderTicketStatus.setExpressType(orderData.getInt("express_type"));
                    orderTicketStatus.setIsStudent(isStudent);
                    orderTicketStatus.setTransferStatus(orderData.getInt("transfer_status"));
                    orderTicketStatus.setStatus(orderData.getInt("status"));
                    orderTicketStatus.setPayStatus(orderData.getInt("pay_status"));
                    orderTicketStatus.setCreatedAt(orderTickets.getCreatedAt());
                    orderTicketStatus.setUpdatedAt(orderTickets.getUpdatedAt());

                    orderTicketRelations.setOrderTicketRelationsId(IDGenerator.nextSnowId().toString());
                    orderTicketRelations.setOrderId(orderTickets.getOrderTicketsId());
                    orderTicketRelations.setTransferId(orderData.getInt("transfer_id") + "");
                    orderTicketRelations.setLiveId(orderData.getInt("live_id") + "");
                    orderTicketRelations.setPerformanceId(orderData.getString("performance_id"));
                    orderTicketRelations.setTimeId("");
                    orderTicketRelations.setTicketId(orderData.getString("ticket_id"));
                    orderTicketRelations.setAgentId(orderData.getString("proxy_id"));
                    orderTicketRelations.setIsMember(orderData.getInt("is_member"));
                    orderTicketRelations.setCreatedAt(orderTickets.getCreatedAt());
                    orderTicketRelations.setUpdatedAt(orderTickets.getUpdatedAt());

                    orderList.add(orderTickets);
                    orderStatusList.add(orderTicketStatus);
                    orderRelationList.add(orderTicketRelations);
//                    orderTicketsMapper.insert(orderTickets);
//                    orderTicketStatusMapper.insert(orderTicketStatus);
//                    orderTicketRelationsMapper.insert(orderTicketRelations);
                    //vo
                    orderTicketVo.setMid(0);
                    orderTicketVo.setOrderTicketsId(orderTickets.getOrderTicketsId());
                    orderTicketVo.setUserId(orderTickets.getUserId());
                    orderTicketVo.setUserName(orderTickets.getUserName());
                    orderTicketVo.setUserMobile(orderTickets.getUserMobile());
                    orderTicketVo.setPerformanceTitle(orderTickets.getPerformanceTitle());
                    orderTicketVo.setTicketTitle(ticketTitle);
                    orderTicketVo.setTimeStart(performanceTimeStart);
                    orderTicketVo.setUseStart(useStart);
                    orderTicketVo.setPerformanceImg(performanceImg);
                    orderTicketVo.setOrderCode(orderTickets.getOrderCode());
                    orderTicketVo.setPayCode(orderTickets.getPayCode());
                    orderTicketVo.setQrCode(orderTickets.getQrCode());
                    orderTicketVo.setOrderType(orderTickets.getOrderType());
                    orderTicketVo.setOrderVersion(orderTickets.getOrderVersion());
                    orderTicketVo.setNumber(orderTickets.getNumber());
                    orderTicketVo.setPrice(orderTickets.getPrice());
                    orderTicketVo.setPriceMember(orderTickets.getPriceMember());
                    orderTicketVo.setPriceTotal(orderTickets.getPriceTotal());
                    orderTicketVo.setPriceVoucher(orderTickets.getPriceVoucher());
                    orderTicketVo.setPriceActual(orderTickets.getPriceActual());
                    orderTicketVo.setPriceExpress(orderTickets.getPriceExpress());
                    orderTicketVo.setPriceRefund(orderTickets.getPriceRefund());
                    orderTicketVo.setRefundNumber(orderTickets.getRefundNumber());
                    orderTicketVo.setPayType(orderTickets.getPayType());
                    orderTicketVo.setPaymentType(orderTickets.getPaymentType());
                    orderTicketVo.setTimePay(orderTickets.getTimePay());
                    orderTicketVo.setExpressContacts(orderTickets.getExpressContacts());
                    orderTicketVo.setExpressAddress(orderTickets.getExpressAddress());
                    orderTicketVo.setExpressPhone(orderTickets.getExpressPhone());
                    orderTicketVo.setCouponType(orderTickets.getCouponType());
                    orderTicketVo.setGetTicketType(orderTickets.getGetTicketType());
                    orderTicketVo.setGetTicketDescribe(orderTickets.getGetTicketDescribe());
                    orderTicketVo.setPayCountdownMinute(orderTickets.getPayCountdownMinute());
                    orderTicketVo.setExpressType(orderTicketStatus.getExpressType());
                    orderTicketVo.setIsStudent(orderTicketStatus.getIsStudent());
                    orderTicketVo.setTransferStatus(orderTicketStatus.getTransferStatus());
                    orderTicketVo.setStatus(orderTicketStatus.getStatus());
                    orderTicketVo.setPayStatus(orderTicketStatus.getPayStatus());
                    orderTicketVo.setTransferId(orderTicketRelations.getTransferId());
                    orderTicketVo.setLiveId(orderTicketRelations.getLiveId());
                    orderTicketVo.setPerformanceId(orderTicketRelations.getPerformanceId());
                    orderTicketVo.setTimeId(orderTicketRelations.getTimeId());
                    orderTicketVo.setTicketId(orderTicketRelations.getTicketId());
                    orderTicketVo.setAgentId(orderTicketRelations.getAgentId());
                    orderTicketVo.setIsMember(orderTicketRelations.getIsMember());
                    orderTicketVo.setCreatedAt(DateUtil.Formatter.yyyyMMddHHmmss.format(orderTickets.getCreatedAt()));
                    orderTicketVo.setUpdatedAt(DateUtil.Formatter.yyyyMMddHHmmss.format(orderTickets.getUpdatedAt()));
                    orderTicketVo.setChangeDate(orderTickets.getUpdatedAt() == null ? orderTickets.getUpdatedAt() : orderTickets.getCreatedAt());
                    orderTicketVo.setIsTrueName(isTrueName);
                    orderTicketVo.setOverdueAt(orderTickets.getCreatedAt().plusMinutes(orderTickets.getPayCountdownMinute()).plusSeconds(15).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                    orderTicketVo.setNoticeImage("[{\"id\":1,\"sort\":1,\"message\":\"因演出票品非普通商品，其背后承载的文化服务具有时效性、稀缺性等特征，故不适用7天无理由退货政策。因“不可抗力”导致的演出取消或延期除外。\",\"title\":\"门票退换\",\"type\":\"image\",\"imgUrl\":\"http://img-zhengzai-tv.oss-cn-hangzhou.aliyuncs.com/partner/2019/01/21/5c45722882a13.png\"},{\"id\":7,\"sort\":2,\"message\":\"凭订单二维码或手机号兑票入场，二维码或手机号请勿泄露，以免影响入场。个人原因导致的信息泄露，主办方/平台方不承担任何责任。\",\"title\":\"电子票\",\"type\":\"image\",\"imgUrl\":\"http://img-zhengzai-tv.oss-cn-hangzhou.aliyuncs.com/partner/2019/01/21/5c456d9482fb9.png\"},{\"id\":3,\"sort\":3,\"message\":\"本场演出不设座位，均为站席观演。\",\"title\":\"仅设站席\",\"type\":\"image\",\"imgUrl\":\"http://img-zhengzai-tv.oss-cn-hangzhou.aliyuncs.com/partner/2019/01/21/5c456e93db0b9.png\"},{\"id\":12,\"sort\":4,\"message\":\"每场现场票数量由场地方决定，具体请到现场询问。\",\"title\":\"现场票\",\"type\":\"image\",\"imgUrl\":\"http://img-zhengzai-tv.oss-cn-hangzhou.aliyuncs.com/partner/2019/06/17/5d07647eaa55f.png\"}]");
                    orderTicketVo.setNotice(notice);
                    orderTicketVo.setTicketType(ticketType);
                    orderTicketVo.setFieldName((String) redisUtil.hget(KylinRedisConst.FIELDS + ":" + orderTicketRelations.getPerformanceId(), "name"));

                    //入场人
                    String enterSql = "select * from order_ticket_entities where order_id = " + orderTickets.getOrderTicketsId(); //设置的预编译语句格式
                    pstmt = con.prepareStatement(enterSql);
                    ResultSet enterData = pstmt.executeQuery();
                    while (enterData.next()) {

                        KylinOrderTicketEntitiesVo entitiesVo = new KylinOrderTicketEntitiesVo();
                        orderTicketEntities.setOrderTicketEntitiesId(enterData.getInt("id") + "");
                        orderTicketEntities.setOrderId(orderTickets.getOrderTicketsId());
                        orderTicketEntities.setTicketId(enterData.getInt("ticket_id") + "");
                        orderTicketEntities.setUserId(enterData.getInt("user_id") + "");
                        orderTicketEntities.setPerformanceId(enterData.getInt("performance_id") + "");
                        orderTicketEntities.setTimeId("");
                        orderTicketEntities.setEnterType(Integer.parseInt(enterData.getString("enter_type")));
                        orderTicketEntities.setEnterName(enterData.getString("enter_name"));
                        orderTicketEntities.setEnterMobile(enterData.getString("enter_mobile"));
                        orderTicketEntities.setEnterIdCode(enterData.getString("enter_idcode"));
                        orderTicketEntities.setStatus(enterData.getInt("status"));
                        orderTicketEntities.setSysDamai(0);
                        orderTicketEntities.setCheckClient("");
                        int isPayment = 0;
                        switch (enterData.getString("is_payment")) {
                            case "yes":
                                isPayment = 1;
                                break;
                            case "no":
                                isPayment = 0;
                                break;
                            case "refunding":
                                isPayment = 2;
                                break;
                            case "refunded":
                                isPayment = 3;
                                break;
                        }
                        orderTicketEntities.setIsPayment(isPayment);
                        orderTicketEntities.setRefundPrice(isPayment == 3 ? orderTickets.getPrice() : new BigDecimal("0.00"));
                        orderTicketEntities.setComment("");
                        orderTicketEntities.setCreatedAt(DateUtil.Formatter.yyyyMMddHHmmssS.parse(orderData.getTimestamp("created_at").toString()));
                        if (null != orderData.getTimestamp("updated_at")) {
                            orderTicketEntities.setUpdatedAt(DateUtil.Formatter.yyyyMMddHHmmssS.parse(orderData.getTimestamp("updated_at").toString()));
                        }

                        orderEntitiesList.add(orderTicketEntities);
//                        orderTicketEntitiesMapper.insert(orderTicketEntities);
                        //vo
                        entitiesVo.setMid(0);
                        entitiesVo.setOrderTicketEntitiesId(orderTicketEntities.getOrderTicketEntitiesId());
                        entitiesVo.setOrderId(orderTicketEntities.getOrderId());
                        entitiesVo.setTicketId(orderTicketEntities.getTicketId());
                        entitiesVo.setUserId(orderTicketEntities.getUserId());
                        entitiesVo.setPerformanceId(orderTicketEntities.getPerformanceId());
                        entitiesVo.setTimeId(orderTicketEntities.getTimeId());
                        entitiesVo.setEnterType(orderTicketEntities.getEnterType());
                        entitiesVo.setEnterName(orderTicketEntities.getEnterName());
                        entitiesVo.setEnterMobile(orderTicketEntities.getEnterMobile());
                        entitiesVo.setEnterIdCode(orderTicketEntities.getEnterIdCode());
                        entitiesVo.setStatus(orderTicketEntities.getStatus());
                        entitiesVo.setSysDamai(orderTicketEntities.getSysDamai());
                        entitiesVo.setCheckClient(orderTicketEntities.getCheckClient());
                        entitiesVo.setIsPayment(orderTicketEntities.getIsPayment());
                        entitiesVo.setPerformanceTitle(orderTickets.getPerformanceTitle());
                        entitiesVo.setTicketTitle(ticketTitle);
                        entitiesVo.setUseStart(useStart);
                        entitiesVo.setUseEnd(useEnd);
                        entitiesVo.setCreatedAt(DateUtil.Formatter.yyyyMMddHHmmss.format(orderTicketEntities.getCreatedAt()));
                        entitiesVo.setUpdatedAt(DateUtil.Formatter.yyyyMMddHHmmss.format(orderTicketEntities.getUpdatedAt()));
                        entitiesVo.setTicketsmId(0);
                        entitiesVo.setTimemId(0);
                        entitiesVo.setChangeDate(orderTicketEntities.getUpdatedAt() == null ? orderTicketEntities.getUpdatedAt() : orderTicketEntities.getCreatedAt());
//                        mongoTemplate.insert(entitiesVo, KylinOrderTicketEntitiesVo.class.getSimpleName());
                        entitiesVosList.add(entitiesVo);
                        orderEntitiesListVo.add(entitiesVo);
                    }
                    orderTicketVo.setEntitiesVoList(entitiesVosList);
                    orderListVo.add(orderTicketVo);
//                    mongoTemplate.insert(orderTicketVo, KylinOrderTicketVo.class.getSimpleName());
                }

                dmCheckOrderTime.saveBatch(orderList);
                dmOrderTicketStatus.saveBatch(orderStatusList);
                dmOrderTicketRelations.saveBatch(orderRelationList);
                dmOrderTicketEntitiesService.saveBatch(orderEntitiesList);

                mongoTemplate.insert(orderListVo, KylinOrderTicketVo.class.getSimpleName());
                mongoTemplate.insert(orderEntitiesListVo, KylinOrderTicketEntitiesVo.class.getSimpleName());

                orderData.last();
                rowCount += orderData.getRow();
                if (allCountResult > rowCount) {
                    isBreak = true;
                    page += 1;
                } else {
                    isBreak = false;
                }

            } while (isBreak);

            return true;
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        } finally {
            //关闭资源,倒关
            try {
                if (rs != null) rs.close();
                if (pstmt != null) pstmt.close();
                if (con != null) con.close();  //必须要关
            } catch (Exception e) {
            }
        }
    }

    public boolean roadShow() {
        String driverClassName = "com.mysql.cj.jdbc.Driver";    //启动驱动
        String url = "jdbc:mysql://pc-2ze6z2hxkug559q79.mysql.polardb.rds.aliyuncs.com:3306/mall";    //设置连接路径
        String username = "readonly";    //数据库用户名
        String password = "ZWDsf8Fy";    //数据库连接密码
        Connection con = null;        //连接
        PreparedStatement pstmt = null;    //使用预编译语句
        ResultSet rs = null;    //获取的结果集

        try {
            ArrayList<KylinRoadShows> roadShowsList = new ArrayList();

            Class.forName(driverClassName); //执行驱动
            con = DriverManager.getConnection(url, username, password); //获取连接
            String sql = "select rs.id,rs.title,rs.img_poster,rs.created_at,rs.updated_at,count(p.id) as 'count' from road_shows as rs left join performances as p on p.road_show_id = rs.id where p.id > 5721  group by rs.id,rs.title having count>0";
            pstmt = con.prepareStatement(sql);
            ResultSet resultData = pstmt.executeQuery();
            //演出数据
            while (resultData.next()) {
                KylinRoadShows roadShows = new KylinRoadShows();
                roadShows.setRoadShowsId(resultData.getInt("id")+"");
                roadShows.setTitle(resultData.getString("title"));
                roadShows.setImgPoster(resultData.getString("img_poster"));
                roadShows.setStatus(1);
                roadShows.setComment("");
                roadShows.setCreatedAt(DateUtil.Formatter.yyyyMMddHHmmssS.parse(resultData.getTimestamp("created_at").toString()));
                if (null != resultData.getTimestamp("updated_at")) {
                    roadShows.setUpdatedAt(DateUtil.Formatter.yyyyMMddHHmmssS.parse(resultData.getTimestamp("updated_at").toString()));
                }
                roadShowsList.add(roadShows);
            }
            dmRoadShowsService.saveBatch(roadShowsList);

            return true;
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        } finally {
            //关闭资源,倒关
            try {
                if (rs != null) rs.close();
                if (pstmt != null) pstmt.close();
                if (con != null) con.close();  //必须要关
            } catch (Exception e) {
            }
        }
    }
}
