package com.liquidnet.client.admin.zhengzai.admin.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.enums.UpushTargetType;
import com.liquidnet.client.admin.common.utils.ShiroUtils;
import com.liquidnet.commons.lang.util.BeanUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.kylin.dao.UpushDetailsListDao;
import com.liquidnet.service.kylin.dto.param.admin.UpushParam;
import com.liquidnet.service.kylin.dto.param.admin.UpushSearchParam;
import com.liquidnet.service.kylin.entity.AdminUpush;
import com.liquidnet.service.kylin.mapper.AdminUpushMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.service.kylin.service.admin.IAdminUpushService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 友盟消息推送 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-07-13
 */
@Service
public class AdminUpushServiceImpl extends ServiceImpl<AdminUpushMapper, AdminUpush> implements IAdminUpushService {

    @Value("${liquidnet.al-oss.imgUrl}")
    private String imgUrl;

    @Autowired
    private AdminUpushMapper adminUpushMapper;

    public Boolean create(UpushParam upushParam) {
        try {
            // 入数据库
            String upushId = IDGenerator.nextSnowId();
            upushParam.setUpushId(upushId);
            upushParam.setCreatedAt(DateUtil.getNowTime());
            String authId = ShiroUtils.getUserId().toString();
            String authName = ShiroUtils.getLoginName();
            upushParam.setPushedBy(authId);
            upushParam.setPushedName(authName);
            AdminUpush adminUpush = new AdminUpush();
            BeanUtils.copyProperties(upushParam, adminUpush);
            if (adminUpush.getPushTime().isEmpty()) {
                adminUpush.setPushTime(null);
            }
            adminUpushMapper.insert(adminUpush);
            return true;
        } catch (Exception e) {
            return false;
        }
    }

    public PageInfo<UpushDetailsListDao> lists(UpushSearchParam upushSearchParam) {
        try {
            PageHelper.startPage(upushSearchParam.getPageNum(), upushSearchParam.getPageSize());
            List<UpushDetailsListDao> voList = adminUpushMapper.searchList(BeanUtil.convertBeanToMap(upushSearchParam));
            for (UpushDetailsListDao item : voList) {
                String typeName = UpushTargetType.getTypeName(item.getJumpType());
                item.setJumpName(typeName);
            }

            return new PageInfo(voList);
        } catch (Exception e) {
            return new PageInfo(new ArrayList());
        }
    }

    public UpushDetailsListDao detail(String upushId) {
        AdminUpush data = adminUpushMapper.selectOne(Wrappers.lambdaQuery(AdminUpush.class).eq(AdminUpush::getUpushId, upushId));
        UpushDetailsListDao upushDetailsListDao = new UpushDetailsListDao();
        if (null != data) {
            String typeName = UpushTargetType.getTypeName(data.getJumpType());
            BeanUtils.copyProperties(data, upushDetailsListDao);
            upushDetailsListDao.setImg(imgUrl + upushDetailsListDao.getImg());
            upushDetailsListDao.setJumpName(typeName);
        } else {
            return null;
        }

        return upushDetailsListDao;
    }
}
