package com.liquidnet.service.sweet.service.impl;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import com.liquidnet.service.sweet.constant.SweetConstant;
import com.liquidnet.service.sweet.entity.SweetWechatUser;
import com.liquidnet.service.sweet.utils.RedisDataUtils;
import com.liquidnet.service.sweet.vo.SweetRemindVo;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.impl.WxMpServiceImpl;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateData;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateMessage;
import me.chanjar.weixin.mp.config.WxMpConfigStorage;
import me.chanjar.weixin.mp.config.impl.WxMpDefaultConfigImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Set;

/**
 * <p>
 * 公众号模版消息 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-07-27
 */
@Service
public class SweetWechatTemplateServiceImpl {

    @Value("${liquidnet.wechat.service.zhengzai.appid}")
    private String appid;
    @Value("${liquidnet.wechat.service.zhengzai.secret}")
    private String secret;

    @Autowired
    private RedisDataUtils redisDataUtils;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private RedisUtil redisUtil;

    public ResponseDto send(String templateId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_REMIND_ALL;
        Set<String> keys = redisTemplate.keys(redisKey);
        if (!CollectionUtils.isEmpty(keys)) {
            for (String rkey : keys) {
                SweetRemindVo remindInfo = (SweetRemindVo) redisUtil.get(rkey);
                SweetWechatUser sweetWechatUser = redisDataUtils.getSweetWechatUser(remindInfo.getUnionId());
                if (null == sweetWechatUser) {
                    continue;
                }
                // 发送模板消息接口
                WxMpTemplateMessage templateMessage = WxMpTemplateMessage.builder()
                        // 接收者openid
                        .toUser(sweetWechatUser.getOpenId())
                        // 模板id
                        .templateId(templateId)
                        // 模板跳转链接
//                        .url("")
                        .build();
                // 添加模板数据
                templateMessage.addData(new WxMpTemplateData("first", "您好"))
                        .addData(new WxMpTemplateData("keyword1", "演出名称"))
                        .addData(new WxMpTemplateData("keyword3", "场馆"))
                        .addData(new WxMpTemplateData("remark", "备注"));
                String msgId = null;
                try {
                    // 发送模板消息
                    WxMpConfigStorage wxMpConfig = wxMpConfig(appid, secret);
                    WxMpService wxMpService = wxMpService(wxMpConfig);
                    msgId = wxMpService.getTemplateMsgService().sendTemplateMsg(templateMessage);
                } catch (WxErrorException e) {
                    e.printStackTrace();
                }
                System.out.println(msgId);
            }
        }
        return ResponseDto.success();
    }

    public ResponseDto sendMsg()
    {
        String templateId = "CNLDBZYQoDgTWudicx8WU81Jr9b6RyG9hmK4O0tpK-k";
        return send(templateId);
    }

    private WxMpConfigStorage wxMpConfig(String appId, String appSecret) {
        WxMpDefaultConfigImpl config = new WxMpDefaultConfigImpl();
        config.setAppId(appId);
        config.setSecret(appSecret);
        return config;
    }

    private WxMpService wxMpService(WxMpConfigStorage mpConfig) {
        WxMpService service = new WxMpServiceImpl();
        service.setWxMpConfigStorage(mpConfig);
        return service;
    }

    public ResponseDto remind(String openId, String unionId, String performancesId) {
        KylinPerformanceVo performanceInfo = (KylinPerformanceVo) redisUtil.get(KylinRedisConst.PERFORMANCES);
        redisDataUtils.setSweetRemind(openId, unionId, performancesId, performanceInfo);
        return ResponseDto.success();
    }
}
