package com.liquidnet.client.admin.zhengzai.kylin.utils;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Value;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

/**
 * <p>
 * 顺丰
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-06-24 8:00 下午
 */
public class ShunfengSignUtils {
    /**
     * appId
     */
    @Value("${liquidnet.shunfeng.appid}")
    private static String APP_ID = "xxx";
    /**
     * sk
     */
    @Value("${liquidnet.shunfeng.sk}")
    private static String SK = "xxx";
    /**
     * 签名有效期（可根据实际业务设定）单位：毫秒
     */
    private final static Long CHECK_TIME = 600000L;



    public static void main(String[] args) {
        // 请求body companyId参数值和APPID一致！！！
        String body="{\"dContact\":\"王昆\",\"companyId\":{{APP_ID}},\"jContact\":\"顺丰\",\"jTel\":\"111\",\"jMobile\":null,\"jAddress\":\"马甸\",\"dTel\":\"064756935\",\"dMobile\":null,\"dAddress\":\"北京市朝阳区花家地金兴路1号院5号楼1单元202\",\"custid\":\"7551234567\",\"payMethod\":\"0\",\"expressType\":\"1\",\"packagesNo\":\"1\",\"depositumInfo\":\"TCL空调\",\"depositumNo\":\"1\",\"remark\":null,\"isCollection\":\"1\",\"collectionMoney\":\"10.00\",\"isReceipt\":\"0\",\"receipt\":null}";
        // 时间戳
        long currentTimeMillis = System.currentTimeMillis();
        System.out.println("时间戳:"+currentTimeMillis);

        // 生成签名并请求
        String result = generateSignatureAndRequest(currentTimeMillis + "", body);
        System.out.println("响应:"+result);
    }



    /**
     * 生成签名并请求
     * @param timestamp 时间戳
     * @param body 请求body
     * @return
     */
    public static String generateSignatureAndRequest(String timestamp, String body) {
        // 生成签名
        String sign = genSign(timestamp,body);
        System.out.println("签名:"+sign);

        CloseableHttpClient client = HttpClients.createDefault();
        // 请求下单地址
        HttpPost httpPost = new HttpPost("https://butler-dev-ms.sf-express.com/public/order/v1/placeOrder");
        // sendAppId（sendAppId需赋值appId）
        httpPost.addHeader("sendAppId", APP_ID);
        // 时间戳需和获取验签时一致！！！
        httpPost.addHeader("timestamp", timestamp);
        // 签名
        httpPost.addHeader("sign", sign);
        httpPost.addHeader("Content-Type", "application/json;charset=utf-8");
        // 请求body体需和获取验签时一致且编码UTF8！！！
        httpPost.setEntity(new StringEntity(body, "utf-8"));
        CloseableHttpResponse response = null;
        try {
            response = client.execute(httpPost);
            if (response.getStatusLine().getStatusCode() == 200) {
                System.out.println("发送请求成功");
                HttpEntity entity = response.getEntity();
                // 发送响应且编码UTF8！！！
                return EntityUtils.toString(entity, "utf-8");
            }
        } catch (Exception e) {
            System.out.println("发送请求失败");
            e.printStackTrace();
        } finally {
            if (client != null) {
                try {
                    client.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (response != null) {
                try {
                    response.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /**
     * 生成签名
     * @param timestamp 时间戳
     * @param body 请求body
     * @return
     */
    private static String genSign(String timestamp, String body) {
        if (StringUtils.isEmpty(body)) {
            body = "";
        }

        StringBuffer sb = new StringBuffer();
        sb.append(body);
        sb.append("&sk=").append(SK);
        sb.append("&timestamp=").append(timestamp);

        byte[] bytes = DigestUtils.sha512(sb.toString());
        return Base64.encodeBase64URLSafeString(bytes);
    }



    /**
     * 接收请求且验签(可在控制层调用此方法)
     * @param params 接收请求参数
     * @param request 接收请求
     * @return
     */
    public static boolean receiveRequestAndCheckSign(String params, HttpServletRequest request) {
        // 请求方APPID
        String sendAppId = request.getHeader("sendAppId");
        // 请求方时间戳
        String timestamp = request.getHeader("timestamp");
        // 请求方签名
        String sign = request.getHeader("sign");
        if (StringUtils.isBlank(sendAppId)) {
            System.out.println("参数sendAppId不能为空");
            return false;
        }
        if (StringUtils.isBlank(timestamp)) {
            System.out.println("参数timestamp不能为空");
            return false;
        }
        if (StringUtils.isBlank(sign)) {
            System.out.println("参数sign不能为空");
            return false;
        }
        // 校验签名是否过期
        long requestTime = Long.parseLong(timestamp);
        long now = System.currentTimeMillis();
        if (Math.abs(now - requestTime) > CHECK_TIME) {
            System.out.println("签名过期!");
            return false;
        }
        // 请求方参数+请求方时间戳+SK 生成签名
        String thisSign = ShunfengSignUtils.genSign(timestamp, params);
        // 获取的签名和请求方签名比较是否一致
        if (!thisSign.equals(sign)) {
            System.out.println("签名错误");
            return false;
        }
        return true;
    }
}
