package com.liquidnet.service.adam.service.impl;

import com.liquidnet.common.mq.constant.MQConst;
import com.liquidnet.commons.lang.util.*;
import com.liquidnet.service.adam.dto.AdamAddressesParam;
import com.liquidnet.service.adam.dto.vo.AdamAddressesVo;
import com.liquidnet.service.adam.service.IAdamAddressesService;
import com.liquidnet.service.adam.service.IAdamRdmService;
import com.liquidnet.service.base.SqlMapping;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import org.bson.Document;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.List;

/**
 * <p>
 * 收货地址 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-11
 */
@Service
public class AdamAddressesServiceImpl implements IAdamAddressesService {
    @Autowired
    MongoConverter mongoConverter;
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    RabbitTemplate rabbitTemplate;
    @Autowired
    IAdamRdmService adamRdmService;

    @Override
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public String add(AdamAddressesParam parameter) {
        String currentUid = CurrentUtil.getCurrentUid();
        LocalDateTime now = LocalDateTime.now();
        String nowStr = DateUtil.Formatter.yyyyMMddHHmmss.format(now);

        List<AdamAddressesVo> vos = adamRdmService.getAddressesVoByUid(currentUid);

        AdamAddressesVo vo = AdamAddressesVo.getNew();
        BeanUtils.copyProperties(parameter, vo);
        vo.setAddressesId(String.valueOf(IDGenerator.nextSnowId()));
        vo.setUid(currentUid);
        vo.setIsDefault(CollectionUtils.isEmpty(vos));
        vo.setState(1);
        vo.setCreatedAt(nowStr);

        mongoTemplate.insert(vo, AdamAddressesVo.class.getSimpleName());

        rabbitTemplate.convertAndSend(MQConst.EXCHANGES_LIQUIDNET_SQL, MQConst.ROUTING_KEY_SQL,
                SqlMapping.get("adam_addresses.add",
                        vo.getAddressesId(), vo.getUid(), vo.getName(), vo.getPhone(), vo.getProvince(), vo.getCity(), vo.getCounty(), vo.getAddress(), vo.getIsDefault(), vo.getState(), now
                )
        );

        vos.add(vo);
        adamRdmService.setAddressesVoByUid(currentUid, vos);
        return vo.getAddressesId();
    }

    @Override
    public void def(String uid, String addressesId) {
        LocalDateTime now = LocalDateTime.now();
        String nowStr = DateUtil.Formatter.yyyyMMddHHmmss.format(now);

        LinkedList<Object[]> toMqObjs = new LinkedList<>();
        List<AdamAddressesVo> vos = adamRdmService.getAddressesVoByUid(uid);
        if (vos.size() > 1) {// 取消原默认
            AdamAddressesVo unDeaultVo = AdamAddressesVo.getNew();
            unDeaultVo.setIsDefault(false);
            unDeaultVo.setUpdatedAt(nowStr);
            Document doc = mongoTemplate.getCollection(AdamAddressesVo.class.getSimpleName()).findOneAndUpdate(
                    Query.query(Criteria.where("uid").is(uid).and("state").is(1).and("isDefault").is(true)).getQueryObject(),
                    new Document("$set", Document.parse(JsonUtils.toJson(unDeaultVo))),
                    new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER)
            );
            if (null != doc) {
                AdamAddressesVo unDefaultVoAfter = BsonUtil.toBean(doc, AdamAddressesVo.class);

                toMqObjs.add(new Object[]{unDeaultVo.getIsDefault(), now, unDefaultVoAfter.getAddressesId()});

                vos.removeIf(r -> r.getAddressesId().equals(unDefaultVoAfter.getAddressesId()));
                vos.add(unDefaultVoAfter);
            }
        }
        {// 设置新默认
            AdamAddressesVo defaultVo = AdamAddressesVo.getNew();
            defaultVo.setIsDefault(true);
            defaultVo.setUpdatedAt(nowStr);
            Document doc = mongoTemplate.getCollection(AdamAddressesVo.class.getSimpleName()).findOneAndUpdate(
                    Query.query(Criteria.where("uid").is(uid).and("addressesId").is(addressesId)).getQueryObject(),
                    new Document("$set", Document.parse(JsonUtils.toJson(defaultVo))),
                    new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER)
            );
            if (null != doc) {
                AdamAddressesVo defaultVoAfter = BsonUtil.toBean(doc, AdamAddressesVo.class);

                toMqObjs.add(new Object[]{defaultVo.getIsDefault(), now, addressesId});

                vos.removeIf(r -> r.getAddressesId().equals(defaultVoAfter.getAddressesId()));
                vos.add(defaultVoAfter);
            }
        }
        if (!CollectionUtils.isEmpty(toMqObjs)) {
            rabbitTemplate.convertAndSend(MQConst.EXCHANGES_LIQUIDNET_SQL, MQConst.ROUTING_KEY_SQL,
                    SqlMapping.get("adam_addresses.update.is_default", toMqObjs));
            adamRdmService.setAddressesVoByUid(uid, vos);
        }
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void edit(AdamAddressesParam parameter) {
        LocalDateTime now = LocalDateTime.now();
        String nowStr = DateUtil.Formatter.yyyyMMddHHmmss.format(now);

        AdamAddressesVo updateVo = AdamAddressesVo.getNew();
        BeanUtils.copyProperties(parameter, updateVo);
        updateVo.setUpdatedAt(nowStr);
        Document doc = mongoTemplate.getCollection(AdamAddressesVo.class.getSimpleName()).findOneAndUpdate(
                Query.query(Criteria.where("addressesId").is(parameter.getAddressesId())).getQueryObject(),
                new Document("$set", Document.parse(JsonUtils.toJson(updateVo))),
                new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER)
        );
        if (null != doc) {
            updateVo = BsonUtil.toBean(doc, AdamAddressesVo.class);
            rabbitTemplate.convertAndSend(MQConst.EXCHANGES_LIQUIDNET_SQL, MQConst.ROUTING_KEY_SQL,
                    SqlMapping.get("adam_addresses.edit",
                            updateVo.getName(), updateVo.getPhone(), updateVo.getProvince(), updateVo.getCity(), updateVo.getCounty(), updateVo.getAddress(), now, updateVo.getAddressesId()
                    )
            );

            String currentUid = CurrentUtil.getCurrentUid();

            List<AdamAddressesVo> vos = adamRdmService.getAddressesVoByUid(currentUid);
            vos.removeIf(r -> r.getAddressesId().equals(parameter.getAddressesId()));
            vos.add(updateVo);
            adamRdmService.setAddressesVoByUid(currentUid, vos);
        }
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void remove(String uid, String addressesId) {
        LocalDateTime now = LocalDateTime.now();
        String nowStr = DateUtil.Formatter.yyyyMMddHHmmss.format(now);

        AdamAddressesVo removeVo = AdamAddressesVo.getNew();
        removeVo.setState(2);
        removeVo.setIsDefault(false);
        removeVo.setUpdatedAt(nowStr);
        removeVo.setDeletedAt(nowStr);

        Document doc = mongoTemplate.getCollection(AdamAddressesVo.class.getSimpleName()).findOneAndUpdate(
                Query.query(Criteria.where("addressesId").is(addressesId)).getQueryObject(),
                new Document("$set", Document.parse(JsonUtils.toJson(removeVo))),
                new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER)
        );
        if (null != doc) {
            rabbitTemplate.convertAndSend(MQConst.EXCHANGES_LIQUIDNET_SQL, MQConst.ROUTING_KEY_SQL,
                    SqlMapping.get("adam_addresses.remove", now, now, addressesId)
            );

            List<AdamAddressesVo> vos = adamRdmService.getAddressesVoByUid(uid);
            vos.removeIf(r -> r.getAddressesId().equals(addressesId));
            adamRdmService.setAddressesVoByUid(uid, vos);
        }
    }

    @Override
    public AdamAddressesVo queryDefault(String uid) {
        List<AdamAddressesVo> vos = adamRdmService.getAddressesVoByUid(uid);
        if (!CollectionUtils.isEmpty(vos)) {
            AdamAddressesVo defaultVo = null;
            for (AdamAddressesVo vo : vos) {
                if (vo.getIsDefault()) {
                    return vo;
                }
                defaultVo = null == defaultVo ? vo :
                        vo.getCreatedAt().compareTo(defaultVo.getCreatedAt()) > 0 ? vo : defaultVo;
            }
            return defaultVo;
        }
        return null;
    }
}
