package com.liquidnet.service.goblin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * <p>
 * 单品关联标签
 * </p>
 *
 * @author liquidnet
 * @since 2022-03-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinGoodsSkuTag implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 单品ID
     */
    private String skuId;

    /**
     * 标签id，对应 goblin_self_goods_tag.tag_id | goblin_self_extag.tag_id
     */
    private String tagId;

    /**
     * 排序[数值越小,排序越前]
     */
    private Integer sort;

    /**
     * 标签所属[0-普通标签|1-专属标签]
     */
    private String tagBelong;

    /**
     * 删除标记[0-未删除|1-删除]
     */
    private String delFlg;

    private String comment;


}
