package com.liquidnet.service.kylin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 福袋活动表
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinLuckyBagActivity implements Serializable, Cloneable{

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * 福袋活动ID
     */
    private String luckyBagActivityId;

    /**
     * 活动名称
     */
    private String name;

    /**
     * 活动简介
     */
    private String detail;


    /**
     * 跳转地址
     */
    private String targetUrl;

    /**
     * 所属演出ID
     */
    private String performanceId;

    /**
     * 状态: 1-可用, 0-不可用
     */
    private Integer state;

    /**
     * 排序（越大越靠前）
     */
    private Integer sort;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 修改时间
     */
    private LocalDateTime updatedAt;
}
