package com.liquidnet.service.kylin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 人流量排队检测摄像头表
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-01-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinCamera implements Serializable, Cloneable {

    private static final long serialVersionUID = 713935834396315177L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * camera_id
     */
    private String cameraId;

    /**
     * 国标ID
     */
    private String gbId;

    /**
     * 截图url
     */
    private String imgUrl;

    /**
     * 场地ID
     */
    private String fieldId;

    /**
     * 地点类型 1卫生间 2。。。
     */
    private Integer siteType;

    /**
     * 设备状态 取值：on(在线),off(离线),failed(锁定),new(未注册)
     */
    private String status;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    private static final KylinCamera obj = new KylinCamera();
    public static KylinCamera getNew() {
        try {
            return (KylinCamera) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinCamera();
        }
    }

}
