package com.liquidnet.service.kylin.dto.vo.admin;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @version V1.0
 * @class: OrderRefundPoundage
 * @Copyright: LightNet @ Copyright (c) 2021
 */
@Data
public class OrderRefundPoundage implements Cloneable {
    @ApiModelProperty(value = "天数")
    private int day;
    @ApiModelProperty(value = "距离演出开始日期>15天")
    private String content;
    @ApiModelProperty(value = "费率 如果手续费是0.1  这里存的是0.9")
    private float present;
    @ApiModelProperty(value = "")
    private int isCanRefund;

    private static final OrderRefundPoundage obj = new OrderRefundPoundage();

    public static OrderRefundPoundage getNew() {
        try {
            return (OrderRefundPoundage) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new OrderRefundPoundage();
        }
    }
}
