package com.liquidnet.client.admin.zhengzai.smile.service.impl;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileSchoolService;
import com.liquidnet.service.smile.entity.SmileSchool;
import com.liquidnet.service.smile.mapper.SmileSchoolMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2022-03-14
 */
@Slf4j
@Service
public class SmileSchoolServiceImpl extends ServiceImpl<SmileSchoolMapper, SmileSchool> implements ISmileSchoolService {

    @Autowired
    SmileSchoolMapper smileSchoolMapper;

    @Override
    public List<SmileSchool> schoolList() {
        return smileSchoolMapper.selectList(null);
    }

    @Override
    public SmileSchool getSchoolById(Long id) {
        return smileSchoolMapper.selectById(id);
    }

    @Override
    public Integer create(SmileSchool smileSchool) {
        log.info("smileSchool:{}",smileSchool);
        return smileSchoolMapper.insert(smileSchool);
    }


}
