package com.liquidnet.service.adam.dto;

import com.liquidnet.commons.lang.constant.LnsRegex;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.*;
import java.io.Serializable;

@ApiModel(value = "AdamMemberOrderCodeParam", description = "使用兑换码入参")
@Data
public class AdamMemberOrderCodeParam implements Serializable {
    private static final long serialVersionUID = 2500742355642406263L;
    @ApiModelProperty(position = 10, required = true, value = "类型:2-会员码,3-礼包码", example = "3")
    @Min(value = 2, message = "类型无效")
    @Max(value = 3, message = "类型无效")
    private Integer mode;
    @ApiModelProperty(position = 11, required = true, value = "兑换码")
    @NotBlank(message = "兑换码不能为空")
    private String memberCode;
    @ApiModelProperty(position = 12, required = true, value = "生日", example = "2021-05-27")
    @Pattern(regexp = LnsRegex.Valid.DATETIME_YMD, message = "生日格式有误")
    @NotBlank(message = "生日不能为空")
    private String birthday;
    @ApiModelProperty(position = 13, required = true, value = "收获地址")
    @Size(min = 1, max = 64, message = "收获地址长度限制1-64位字符")
    @NotBlank(message = "收获地址不能为空")
    private String addressId;
    @ApiModelProperty(position = 14, value = "支付终端[app,wap,js,applet]", example = "js")
    private String deviceFrom;
    @ApiModelProperty(position = 15, required = false, value = "姓名[未实名时必传]")
    private String name;
    @ApiModelProperty(position = 16, required = false, value = "身份证件号[未实名时必传]")
    private String idCard;
}
