package com.liquidnet.service.kylin.dto.param;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.kylin.entity.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;


/**
 * 修改场地全部显示数据参数
 */
@Data
public class TicketCreateParam implements Serializable {
    @ApiModelProperty(value = "主键")
    private String ticketsId;

    @ApiModelProperty(value = "场次Id")
    private String timesId;

    @ApiModelProperty(value = "票种名称", example = "测试票")
    private String title;

    @ApiModelProperty(value = "类型", example = "2")
    private int types;

    @ApiModelProperty(value = "是否学生票 0否 1是", example = "0")
    private int isStudent;

    @ApiModelProperty(value = "是否电子票", example = "0")
    private int isElectronic;

    @ApiModelProperty(value = "是否快递票", example = "0")
    private int isExpress;

    @ApiModelProperty(value = "价格", example = "100.00")
    private BigDecimal price;

    @ApiModelProperty(value = "快递票截止日期", example = "2020-12-01T12:00:00")
    private LocalDateTime timeEndExpress;

    @ApiModelProperty(value = "总库存", example = "100")
    private int totalGeneral;

    @ApiModelProperty(value = "总兑换库存", example = "100")
    private int totalExchange;

    @ApiModelProperty(value = "限购数量", example = "0")
    private int limitCount;

    @ApiModelProperty(value = "票种开售时间", example = "2020-12-01T12:00:00")
    private LocalDateTime timeStart;

    @ApiModelProperty(value = "票种结售时间", example = "2020-12-01T14:00:00")
    private LocalDateTime timeEnd;

    @ApiModelProperty(value = "票种说明", example = "这是票种说明")
    private String describes;

    @ApiModelProperty(value = "是否展示二维码 0否 1是", example = "0")
    private int isShowCode;

    @ApiModelProperty(value = "二维码显示时间", example = "2020-12-01T14:00:00")
    private LocalDateTime qrCodeShowTime;

    @ApiModelProperty(value = "是否开启缺票登记", example = "1")
    private int isLackRegister;

    @ApiModelProperty(value = "", hidden = true)
    private String createdAt;

    @JsonIgnore
    public KylinTickets kylinTickets(String ticketsId, LocalDateTime createdAt, LocalDateTime updatedAt) {
        KylinTickets kylinTickets = new KylinTickets();
        BeanUtils.copyProperties(this, kylinTickets);
        kylinTickets.setTicketsId(ticketsId);
        kylinTickets.setPriceDiscount(BigDecimal.valueOf(0.00));
        kylinTickets.setPriceDiscountMember(BigDecimal.valueOf(0.00));
        if (createdAt != null)
            kylinTickets.setCreatedAt(createdAt);
        if (updatedAt != null)
            kylinTickets.setUpdatedAt(updatedAt);
        //TODO 各种说明文案
        return kylinTickets;
    }

    @JsonIgnore
    public KylinTicketStatus kylinTicketStatus(String ticketsId, LocalDateTime createdAt, LocalDateTime updatedAt) {
        KylinTicketStatus kylinTicketStatus = new KylinTicketStatus();
        BeanUtils.copyProperties(this, kylinTicketStatus);
        kylinTicketStatus.setTicketStatusId(IDGenerator.nextSnowId().toString());
        kylinTicketStatus.setTicketId(ticketsId);
        kylinTicketStatus.setStatusExchange(7);
        kylinTicketStatus.setSurplusExchange(this.totalExchange);
        kylinTicketStatus.setSurplusGeneral(this.totalGeneral);
        if (createdAt != null)
            kylinTicketStatus.setCreatedAt(createdAt);
        if (updatedAt != null)
            kylinTicketStatus.setUpdatedAt(updatedAt);
        return kylinTicketStatus;
    }

    @JsonIgnore
    public KylinTicketRelations kylinTicketRelations(String ticketsId, LocalDateTime createdAt, LocalDateTime updatedAt) {
        KylinTicketRelations kylinTicketRelations = new KylinTicketRelations();
        BeanUtils.copyProperties(this, kylinTicketRelations);
        kylinTicketRelations.setTicketId(ticketsId);
        kylinTicketRelations.setTicketRelationsId(IDGenerator.nextSnowId().toString());
        if (createdAt != null)
            kylinTicketRelations.setCreatedAt(createdAt);
        if (updatedAt != null)
            kylinTicketRelations.setUpdatedAt(updatedAt);
        return kylinTicketRelations;
    }
}