package com.liquidnet.service.kylin.controller;

import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.kylin.dto.vo.FieldsVo;
import com.liquidnet.service.kylin.service.impl.FieldsServiceImpl;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;

@Api
@RestController
@RequestMapping("/user/fields")
public class FieldsController {

    @Autowired
    private FieldsServiceImpl fieldsService;

    @GetMapping(value = "details")
    @ApiOperation(value = "获取场地详情")
    @ApiResponse(response = FieldsVo.class, code = 200, message = "接口返回对象参数")
    public ResponseDto<FieldsVo> fieldDetails(@RequestParam(value = "fieldId", defaultValue = "59666659929161728") String fieldId) {
        FieldsVo result = null;
        result = fieldsService.fieldDetails(fieldId);
        if (null == result) {
            return ResponseDto.failure("场地详情查询失败");
        } else {
            return ResponseDto.success(result);
        }
    }

    @GetMapping(value = "list")
    @ApiOperation(value = "获取场地列表")
    @ApiResponse(response = FieldsVo.class, code = 200, message = "接口返回对象参数")
    public ResponseDto<HashMap<String, Object>> fieldList(@RequestParam(value = "page", defaultValue = "1") int page,@RequestParam(value = "size", defaultValue = "10") int size,@RequestParam(value = "city_id", defaultValue = "1") int city_id) {
        HashMap<String, Object> result = null;
        result = fieldsService.fieldList(page-1,size,city_id);
        if (null == result) {
            return ResponseDto.failure("场地列表获取失败");
        } else {
            return ResponseDto.success(result);
        }
    }
}
